/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Functions;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;

public final class RxUtil {
    private static final Logger log = LoggerFactory.getLogger(RxUtil.class);

    private RxUtil() {
    }

    public static <T> Observable<T> concatButIgnoreFirstSequence(Observable<?> o1, Observable<T> o2) {
        return Observable.concat((Observable)o1.ignoreElements(), o2);
    }

    public static <T> Observer<? super T> log() {
        return new Observer<T>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                log.error(e.getMessage(), e);
            }

            public void onNext(T t) {
                log.info(t + "");
            }
        };
    }

    public static <T> CountingAction<T> counter() {
        return new CountingAction();
    }

    public static <T extends Number> Func1<T, Boolean> greaterThanZero() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return ((Number)t).doubleValue() > 0.0;
            }
        };
    }

    public static <T> Func1<T, Observable<Object>> toEmpty() {
        return Functions.constant((Object)Observable.empty());
    }

    public static <T> Observable.Transformer<Observable<T>, T> flatten() {
        return new Observable.Transformer<Observable<T>, T>(){

            public Observable<T> call(Observable<Observable<T>> source) {
                return source.flatMap(Functions.identity());
            }
        };
    }

    public static <T> long getAndAddRequest(AtomicLongFieldUpdater<T> requested, T object, long n) {
        long next;
        long current;
        do {
            if ((next = (current = requested.get(object)) + n) >= 0L) continue;
            next = Long.MAX_VALUE;
        } while (!requested.compareAndSet(object, current, next));
        return current;
    }

    public static long getAndAddRequest(AtomicLong requested, long n) {
        long next;
        long current;
        do {
            if ((next = (current = requested.get()) + n) >= 0L) continue;
            next = Long.MAX_VALUE;
        } while (!requested.compareAndSet(current, next));
        return current;
    }

    public static class CountingAction<T>
    implements Action1<T> {
        private final AtomicLong count = new AtomicLong(0L);

        public Observable<Long> count() {
            return Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<Long>(){

                public void call(Subscriber<? super Long> subscriber) {
                    subscriber.onNext((Object)CountingAction.this.count.get());
                    subscriber.onCompleted();
                }
            });
        }

        public void call(T t) {
            this.count.incrementAndGet();
        }
    }
}

