/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class CommandFactory {
    private static final Map<Boolean, Map<String, Class<? extends RedisOperation>>> commands;

    public static RedisOperation buildOperation(String name, boolean transactional, OperationExecutorState state, List<Slice> params) {
        Class<? extends RedisOperation> commandClass = commands.get(transactional).get(name);
        if (commandClass != null) {
            try {
                Constructor<?> declaredConstructor = commandClass.getDeclaredConstructors()[0];
                Class<?>[] parameterTypes = declaredConstructor.getParameterTypes();
                Constructor<? extends RedisOperation> constructor = commandClass.getDeclaredConstructor(parameterTypes);
                constructor.setAccessible(true);
                Object[] parameters = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (parameterTypes[i].isAssignableFrom(List.class)) {
                        parameters[i] = params;
                        continue;
                    }
                    if (parameterTypes[i].isAssignableFrom(OperationExecutorState.class)) {
                        parameters[i] = state;
                        continue;
                    }
                    if (parameterTypes[i].isAssignableFrom(RedisBase.class)) {
                        parameters[i] = state.base();
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Cannot resolve parameter of type %s for command %s", parameterTypes[i].getSimpleName(), name));
                }
                return constructor.newInstance(parameters);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static void initialize() {
    }

    static {
        Reflections scanner = new Reflections(CommandFactory.class.getPackage().getName(), new Scanner[0]);
        Set redisOperations = scanner.getSubTypesOf(RedisOperation.class);
        commands = redisOperations.stream().filter(ReflectionUtils.withAnnotation(RedisCommand.class)).collect(Collectors.groupingBy(c -> c.getAnnotation(RedisCommand.class).transactional(), Collectors.toMap(c -> c.getAnnotation(RedisCommand.class).value(), Function.identity())));
    }
}

