/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.hyperloglog;

import com.github.fppt.jedismock.datastructures.RMHyperLogLog;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="pfmerge")
class PFMerge
extends AbstractRedisOperation {
    PFMerge(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        RMHyperLogLog rmData = this.base().getHLL(key);
        RMHyperLogLog set = rmData == null ? new RMHyperLogLog() : rmData;
        for (Slice v : this.params().subList(1, this.params().size())) {
            RMHyperLogLog valueToMerge = this.base().getHLL(v);
            if (valueToMerge == null) continue;
            set.addAll(valueToMerge.getStoredData());
        }
        this.base().putValue(key, set);
        return Response.OK;
    }
}

