/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;
import java.util.stream.Collectors;

@RedisCommand(value="copy")
public class Copy
implements RedisOperation {
    private final OperationExecutorState state;
    private final List<Slice> params;
    private final List<String> additionalParams;

    public Copy(OperationExecutorState state, List<Slice> params) {
        this.params = params;
        this.state = state;
        this.additionalParams = params.stream().skip(2L).map(Slice::toString).collect(Collectors.toList());
    }

    private Integer destinationDb() {
        String previous = null;
        for (String param : this.additionalParams) {
            if ("db".equalsIgnoreCase(previous)) {
                return Utils.convertToInteger(param);
            }
            previous = param;
        }
        return null;
    }

    private boolean replace() {
        return this.additionalParams.stream().anyMatch("replace"::equalsIgnoreCase);
    }

    @Override
    public Slice execute() {
        RedisBase destinationBase;
        if (this.params.size() < 2) {
            return Response.error("ERR wrong number of arguments for 'copy' command");
        }
        Slice source = this.params.get(0);
        Slice destination = this.params.get(1);
        RedisBase sourceBase = this.state.base();
        RMDataStructure value = sourceBase.getValue(source);
        if (value == null) {
            return Response.integer(0L);
        }
        Integer destinationIdx = this.destinationDb();
        RedisBase redisBase = destinationBase = destinationIdx == null ? this.state.base() : this.state.base(destinationIdx);
        if (destinationBase.exists(destination)) {
            if (this.replace()) {
                destinationBase.deleteValue(destination);
            } else {
                return Response.integer(0L);
            }
        }
        destinationBase.putValue(destination, value);
        Long deadline = sourceBase.getDeadline(source);
        if (deadline != null) {
            destinationBase.setDeadline(destination, deadline);
        }
        return Response.integer(1L);
    }
}

