/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="move")
public class Move
implements RedisOperation {
    private final OperationExecutorState state;
    private final List<Slice> params;

    public Move(OperationExecutorState state, List<Slice> params) {
        this.params = params;
        this.state = state;
    }

    RedisBase base() {
        return this.state.base();
    }

    @Override
    public Slice execute() {
        if (this.params.size() != 2) {
            return Response.error("ERR wrong number of arguments for 'move' command");
        }
        Slice key = this.params.get(0);
        int destinationIdx = Utils.convertToInteger(this.params.get(1).toString());
        RMDataStructure value = this.state.base().getValue(key);
        if (value == null) {
            return Response.integer(0L);
        }
        RedisBase destinationBase = this.state.base(destinationIdx);
        if (destinationBase.exists(key)) {
            return Response.integer(0L);
        }
        destinationBase.putValue(key, value);
        Long deadline = this.state.base().getDeadline(key);
        if (deadline != null) {
            destinationBase.setDeadline(key, deadline);
        }
        this.state.base().deleteValue(key);
        return Response.integer(1L);
    }
}

