/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.RMDataStructure;
import com.github.fppt.jedismock.datastructures.RMList;
import com.github.fppt.jedismock.datastructures.RMSet;
import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.datastructures.ZSetEntry;
import com.github.fppt.jedismock.exception.WrongValueTypeException;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@RedisCommand(value="sort")
public class Sort
extends AbstractRedisOperation {
    private static final String LIMIT_PARAM = "LIMIT";
    private static final String ALPHA_PARAM = "ALPHA";
    private static final String STORE_PARAM = "STORE";
    private static final String DESC_PARAM = "DESC";
    private final Object lock;
    private boolean sortNumerically = true;
    private Slice storeTo = null;
    private int offset = 0;
    private int count = Integer.MAX_VALUE;
    private int compareMultiplier = 1;

    public Sort(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    @Override
    protected Slice response() {
        Slice key = this.params().get(0);
        this.parseArgs();
        Slice[] items = this.getItems(key);
        try {
            Arrays.sort(items, this::compare);
        }
        catch (WrongValueTypeException e) {
            throw new WrongValueTypeException("ERR One or more scores can't be converted into double");
        }
        List<Slice> sorted = Arrays.stream(items).skip(this.offset).limit(this.count).collect(Collectors.toList());
        if (this.storeTo != null) {
            this.base().putValue(this.storeTo, new RMList(sorted));
            this.lock.notifyAll();
            return Response.integer(sorted.size());
        }
        return Response.array(sorted.stream().map(Response::bulkString).collect(Collectors.toList()));
    }

    private Slice[] getItems(Slice key) {
        RMDataStructure dataStructure = this.base().getValue(key);
        if (dataStructure instanceof RMList) {
            return ((RMList)dataStructure).getStoredData().toArray(new Slice[0]);
        }
        if (dataStructure instanceof RMSet) {
            return ((RMSet)dataStructure).getStoredData().toArray(new Slice[0]);
        }
        if (dataStructure instanceof RMZSet) {
            return (Slice[])((RMZSet)dataStructure).entries(false).stream().map(ZSetEntry::getValue).toArray(Slice[]::new);
        }
        throw new WrongValueTypeException("WRONGTYPE Operation against a key holding the wrong kind of value");
    }

    private int compare(Slice a, Slice b) {
        return (this.sortNumerically ? Double.compare(Utils.convertToDouble(a.toString()), Utils.convertToDouble(b.toString())) : a.compareTo(b)) * this.compareMultiplier;
    }

    private void parseArgs() {
        List<Slice> params = this.params();
        for (int i = 1; i < params.size(); ++i) {
            if (ALPHA_PARAM.equalsIgnoreCase(params.get(i).toString())) {
                this.sortNumerically = false;
            }
            if (STORE_PARAM.equalsIgnoreCase(params.get(i).toString())) {
                this.storeTo = params.get(i + 1);
                ++i;
            }
            if (LIMIT_PARAM.equalsIgnoreCase(params.get(i).toString())) {
                this.offset = Math.max(Utils.convertToInteger(params.get(i + 1).toString()), 0);
                this.count = Utils.convertToInteger(params.get(i + 2).toString());
                i += 2;
            }
            if (!DESC_PARAM.equalsIgnoreCase(params.get(i).toString())) continue;
            this.compareMultiplier = -1;
        }
    }
}

