/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jfilechooserbookmarks.core;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Utils {
    public static String throwableToString(Throwable t) {
        return Utils.throwableToString(t, -1);
    }

    public static String throwableToString(Throwable t, int maxLines) {
        StringBuilder result;
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        if (maxLines > 0) {
            result = new StringBuilder();
            String[] lines = writer.toString().split("\n");
            for (int i = 0; i < maxLines; ++i) {
                if (i > 0) {
                    result.append("\n");
                }
                result.append(lines[i]);
            }
        } else {
            result = new StringBuilder(writer.toString());
        }
        return result.toString();
    }

    public static String getStackTrace(int maxDepth) {
        StringBuilder result = new StringBuilder();
        Throwable th = new Throwable();
        th.fillInStackTrace();
        StackTraceElement[] trace = th.getStackTrace();
        if (maxDepth <= 0) {
            maxDepth = trace.length - 1;
        }
        ++maxDepth;
        maxDepth = Math.min(maxDepth, trace.length);
        for (int i = 1; i < maxDepth; ++i) {
            if (i > 1) {
                result.append("\n");
            }
            result.append(trace[i]);
        }
        return result.toString();
    }
}

