/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.cache;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.cache.CachedFile;
import com.github.klieber.phantomjs.util.ArtifactBuilder;
import java.io.File;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.LocalRepositoryManager;

public class CachedArtifact
implements CachedFile {
    private final PhantomJSArchive phantomJSArchive;
    private final ArtifactBuilder artifactBuilder;
    private final RepositorySystemSession repositorySystemSession;

    public CachedArtifact(PhantomJSArchive phantomJSArchive, ArtifactBuilder artifactBuilder, RepositorySystemSession repositorySystemSession) {
        this.phantomJSArchive = phantomJSArchive;
        this.artifactBuilder = artifactBuilder;
        this.repositorySystemSession = repositorySystemSession;
    }

    @Override
    public File getFile() {
        Artifact artifact = this.artifactBuilder.createArtifact(this.phantomJSArchive);
        LocalRepositoryManager manager = this.repositorySystemSession.getLocalRepositoryManager();
        return new File(manager.getRepository().getBasedir(), manager.getPathForLocalArtifact(artifact));
    }
}

