/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.download;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.download.DownloadException;
import com.github.klieber.phantomjs.download.Downloader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDownloader
implements Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDownloader.class);
    private static final String DOWNLOADING = "Downloading phantomjs binary from {}";
    private static final String UNABLE_TO_DOWNLOAD = "Unable to download phantomjs binary from ";
    private final String baseUrl;
    private final File target;

    public WebDownloader(String baseUrl, File target) {
        this.baseUrl = baseUrl;
        this.target = target;
    }

    @Override
    public File download(PhantomJSArchive archive) throws DownloadException {
        if (!this.target.exists()) {
            String url = this.buildDownloadUrl(archive);
            try {
                URL downloadLocation = new URL(url);
                LOGGER.info(DOWNLOADING, (Object)url);
                FileUtils.copyURLToFile((URL)downloadLocation, (File)this.target);
                if (this.target.length() <= 0L) {
                    throw new DownloadException(UNABLE_TO_DOWNLOAD + url);
                }
            }
            catch (MalformedURLException e) {
                throw new DownloadException(UNABLE_TO_DOWNLOAD + url, e);
            }
            catch (IOException e) {
                throw new DownloadException(UNABLE_TO_DOWNLOAD + url, e);
            }
        }
        return this.target;
    }

    private String buildDownloadUrl(PhantomJSArchive archive) {
        StringBuilder url = new StringBuilder();
        url.append(this.baseUrl);
        if (!this.baseUrl.endsWith("/")) {
            url.append("/");
        }
        url.append(archive.getArchiveName());
        return url.toString();
    }
}

