/*
 * Decompiled with CFR 0.152.
 */
package com.github.marlonlom.utilities.timeago;

import com.github.marlonlom.utilities.timeago.TimeAgo$Companion$WhenMappings;
import com.github.marlonlom.utilities.timeago.TimeAgoMessages;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgo;", "", "()V", "Companion", "DistancePredicate", "Periods", "ta_library"})
public final class TimeAgo {
    public static final Companion Companion = new Companion(null);

    private TimeAgo() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String using(long time, @NotNull TimeAgoMessages resources) {
        return Companion.using(time, resources);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String using(long time) {
        return com.github.marlonlom.utilities.timeago.TimeAgo$Companion.using$default(Companion, time, null, 2, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\b\u0082\u0001\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\"B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!\u00a8\u0006#"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgo$Periods;", "", "propertyKey", "", "predicate", "Lcom/github/marlonlom/utilities/timeago/TimeAgo$DistancePredicate;", "(Ljava/lang/String;ILjava/lang/String;Lcom/github/marlonlom/utilities/timeago/TimeAgo$DistancePredicate;)V", "getPropertyKey", "()Ljava/lang/String;", "NOW", "ONEMINUTE_PAST", "XMINUTES_PAST", "ABOUTANHOUR_PAST", "XHOURS_PAST", "ONEDAY_PAST", "XDAYS_PAST", "ABOUTAMONTH_PAST", "XMONTHS_PAST", "ABOUTAYEAR_PAST", "OVERAYEAR_PAST", "ALMOSTTWOYEARS_PAST", "XYEARS_PAST", "ONEMINUTE_FUTURE", "XMINUTES_FUTURE", "ABOUTANHOUR_FUTURE", "XHOURS_FUTURE", "ONEDAY_FUTURE", "XDAYS_FUTURE", "ABOUTAMONTH_FUTURE", "XMONTHS_FUTURE", "ABOUTAYEAR_FUTURE", "OVERAYEAR_FUTURE", "ALMOSTTWOYEARS_FUTURE", "XYEARS_FUTURE", "Companion", "ta_library"})
    private static final class Periods
    extends Enum<Periods> {
        public static final /* enum */ Periods NOW;
        public static final /* enum */ Periods ONEMINUTE_PAST;
        public static final /* enum */ Periods XMINUTES_PAST;
        public static final /* enum */ Periods ABOUTANHOUR_PAST;
        public static final /* enum */ Periods XHOURS_PAST;
        public static final /* enum */ Periods ONEDAY_PAST;
        public static final /* enum */ Periods XDAYS_PAST;
        public static final /* enum */ Periods ABOUTAMONTH_PAST;
        public static final /* enum */ Periods XMONTHS_PAST;
        public static final /* enum */ Periods ABOUTAYEAR_PAST;
        public static final /* enum */ Periods OVERAYEAR_PAST;
        public static final /* enum */ Periods ALMOSTTWOYEARS_PAST;
        public static final /* enum */ Periods XYEARS_PAST;
        public static final /* enum */ Periods ONEMINUTE_FUTURE;
        public static final /* enum */ Periods XMINUTES_FUTURE;
        public static final /* enum */ Periods ABOUTANHOUR_FUTURE;
        public static final /* enum */ Periods XHOURS_FUTURE;
        public static final /* enum */ Periods ONEDAY_FUTURE;
        public static final /* enum */ Periods XDAYS_FUTURE;
        public static final /* enum */ Periods ABOUTAMONTH_FUTURE;
        public static final /* enum */ Periods XMONTHS_FUTURE;
        public static final /* enum */ Periods ABOUTAYEAR_FUTURE;
        public static final /* enum */ Periods OVERAYEAR_FUTURE;
        public static final /* enum */ Periods ALMOSTTWOYEARS_FUTURE;
        public static final /* enum */ Periods XYEARS_FUTURE;
        private static final /* synthetic */ Periods[] $VALUES;
        @NotNull
        private final String propertyKey;
        private final DistancePredicate predicate;
        public static final Companion Companion;

        static {
            Periods[] periodsArray = new Periods[25];
            Periods[] periodsArray2 = periodsArray;
            periodsArray[0] = NOW = new Periods("ml.timeago.now", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance == 0L;
                }
            });
            periodsArray[1] = ONEMINUTE_PAST = new Periods("ml.timeago.oneminute.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance == 1L;
                }
            });
            periodsArray[2] = XMINUTES_PAST = new Periods("ml.timeago.xminutes.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)2 && distance <= (long)44;
                }
            });
            periodsArray[3] = ABOUTANHOUR_PAST = new Periods("ml.timeago.aboutanhour.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)45 && distance <= (long)89;
                }
            });
            periodsArray[4] = XHOURS_PAST = new Periods("ml.timeago.xhours.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)90 && distance <= (long)1439;
                }
            });
            periodsArray[5] = ONEDAY_PAST = new Periods("ml.timeago.oneday.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)1440 && distance <= (long)2519;
                }
            });
            periodsArray[6] = XDAYS_PAST = new Periods("ml.timeago.xdays.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)2520 && distance <= (long)43199;
                }
            });
            periodsArray[7] = ABOUTAMONTH_PAST = new Periods("ml.timeago.aboutamonth.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)43200 && distance <= (long)86399;
                }
            });
            periodsArray[8] = XMONTHS_PAST = new Periods("ml.timeago.xmonths.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)86400 && distance <= (long)525599;
                }
            });
            periodsArray[9] = ABOUTAYEAR_PAST = new Periods("ml.timeago.aboutayear.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)525600 && distance <= (long)655199;
                }
            });
            periodsArray[10] = OVERAYEAR_PAST = new Periods("ml.timeago.overayear.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)655200 && distance <= (long)914399;
                }
            });
            periodsArray[11] = ALMOSTTWOYEARS_PAST = new Periods("ml.timeago.almosttwoyears.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance >= (long)914400 && distance <= (long)1051199;
                }
            });
            periodsArray[12] = XYEARS_PAST = new Periods("ml.timeago.xyears.past", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return Math.round(distance / (long)525600) > 1;
                }
            });
            periodsArray[13] = ONEMINUTE_FUTURE = new Periods("ml.timeago.oneminute.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return (int)distance == -1;
                }
            });
            periodsArray[14] = XMINUTES_FUTURE = new Periods("ml.timeago.xminutes.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-2 && distance >= (long)-44;
                }
            });
            periodsArray[15] = ABOUTANHOUR_FUTURE = new Periods("ml.timeago.aboutanhour.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-45 && distance >= (long)-89;
                }
            });
            periodsArray[16] = XHOURS_FUTURE = new Periods("ml.timeago.xhours.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-90 && distance >= (long)-1439;
                }
            });
            periodsArray[17] = ONEDAY_FUTURE = new Periods("ml.timeago.oneday.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-1440 && distance >= (long)-2519;
                }
            });
            periodsArray[18] = XDAYS_FUTURE = new Periods("ml.timeago.xdays.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-2520 && distance >= (long)-43199;
                }
            });
            periodsArray[19] = ABOUTAMONTH_FUTURE = new Periods("ml.timeago.aboutamonth.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-43200 && distance >= (long)-86399;
                }
            });
            periodsArray[20] = XMONTHS_FUTURE = new Periods("ml.timeago.xmonths.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-86400 && distance >= (long)-525599;
                }
            });
            periodsArray[21] = ABOUTAYEAR_FUTURE = new Periods("ml.timeago.aboutayear.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-525600 && distance >= (long)-655199;
                }
            });
            periodsArray[22] = OVERAYEAR_FUTURE = new Periods("ml.timeago.overayear.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-655200 && distance >= (long)-914399;
                }
            });
            periodsArray[23] = ALMOSTTWOYEARS_FUTURE = new Periods("ml.timeago.almosttwoyears.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return distance <= (long)-914400 && distance >= (long)-1051199;
                }
            });
            periodsArray[24] = XYEARS_FUTURE = new Periods("ml.timeago.xyears.future", new DistancePredicate(){

                @Override
                public boolean validateDistanceMinutes(long distance) {
                    return Math.round(distance / (long)525600) < -1;
                }
            });
            $VALUES = periodsArray;
            Companion = new Companion(null);
        }

        @NotNull
        public final String getPropertyKey() {
            return this.propertyKey;
        }

        private Periods(String propertyKey, DistancePredicate predicate) {
            this.propertyKey = propertyKey;
            this.predicate = predicate;
        }

        public static Periods[] values() {
            return (Periods[])$VALUES.clone();
        }

        public static Periods valueOf(String string) {
            return Enum.valueOf(Periods.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgo$Periods$Companion;", "", "()V", "findByDistanceMinutes", "Lcom/github/marlonlom/utilities/timeago/TimeAgo$Periods;", "distanceMinutes", "", "ta_library"})
        public static final class Companion {
            @Nullable
            public final Periods findByDistanceMinutes(long distanceMinutes) {
                Periods[] values;
                for (Periods item : values = Periods.values()) {
                    boolean successful = item.predicate.validateDistanceMinutes(distanceMinutes);
                    if (!successful) continue;
                    return item;
                }
                return null;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgo$DistancePredicate;", "", "validateDistanceMinutes", "", "distance", "", "ta_library"})
    private static interface DistancePredicate {
        public boolean validateDistanceMinutes(long var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/github/marlonlom/utilities/timeago/TimeAgo$Companion;", "", "()V", "buildTimeagoText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "resources", "Lcom/github/marlonlom/utilities/timeago/TimeAgoMessages;", "dim", "", "getTimeDistanceInMinutes", "time", "handlePeriodKeyAsPlural", "", "periodKey", "pluralKey", "value", "", "using", "ta_library"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String using(long time, @NotNull TimeAgoMessages resources) {
            Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
            long dim = this.getTimeDistanceInMinutes(time);
            StringBuilder timeAgo = this.buildTimeagoText(resources, dim);
            String string = timeAgo.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"timeAgo.toString()");
            return string;
        }

        public static /* synthetic */ String using$default(Companion companion, long l, TimeAgoMessages timeAgoMessages, int n, Object object) {
            if ((n & 2) != 0) {
                timeAgoMessages = new TimeAgoMessages.Builder().defaultLocale().build();
            }
            return companion.using(l, timeAgoMessages);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String using(long time) {
            return com.github.marlonlom.utilities.timeago.TimeAgo$Companion.using$default(this, time, null, 2, null);
        }

        private final StringBuilder buildTimeagoText(TimeAgoMessages resources, long dim) {
            StringBuilder timeAgo = new StringBuilder();
            Periods foundTimePeriod = Periods.Companion.findByDistanceMinutes(dim);
            if (foundTimePeriod != null) {
                String periodKey = foundTimePeriod.getPropertyKey();
                switch (TimeAgo$Companion$WhenMappings.$EnumSwitchMapping$0[foundTimePeriod.ordinal()]) {
                    case 1: {
                        timeAgo.append(resources.getPropertyValue(periodKey, dim));
                        break;
                    }
                    case 2: {
                        int hours = Math.round(dim / (long)60);
                        String xHoursText = this.handlePeriodKeyAsPlural(resources, "ml.timeago.aboutanhour.past", periodKey, hours);
                        timeAgo.append(xHoursText);
                        break;
                    }
                    case 3: {
                        int days = Math.round(dim / (long)1440);
                        String xDaysText = this.handlePeriodKeyAsPlural(resources, "ml.timeago.oneday.past", periodKey, days);
                        timeAgo.append(xDaysText);
                        break;
                    }
                    case 4: {
                        int months = Math.round(dim / (long)43200);
                        String xMonthsText = this.handlePeriodKeyAsPlural(resources, "ml.timeago.aboutamonth.past", periodKey, months);
                        timeAgo.append(xMonthsText);
                        break;
                    }
                    case 5: {
                        int years = Math.round(dim / (long)525600);
                        timeAgo.append(resources.getPropertyValue(periodKey, years));
                        break;
                    }
                    case 6: {
                        timeAgo.append(resources.getPropertyValue(periodKey, Float.valueOf(Math.abs((float)dim))));
                        break;
                    }
                    case 7: {
                        int hours1 = Math.abs(Math.round((float)dim / 60.0f));
                        String yHoursText = hours1 == 24 ? resources.getPropertyValue("ml.timeago.oneday.future") : this.handlePeriodKeyAsPlural(resources, "ml.timeago.aboutanhour.future", periodKey, hours1);
                        timeAgo.append(yHoursText);
                        break;
                    }
                    case 8: {
                        int days1 = Math.abs(Math.round((float)dim / 1440.0f));
                        String yDaysText = this.handlePeriodKeyAsPlural(resources, "ml.timeago.oneday.future", periodKey, days1);
                        timeAgo.append(yDaysText);
                        break;
                    }
                    case 9: {
                        int months1 = Math.abs(Math.round((float)dim / 43200.0f));
                        String yMonthsText = months1 == 12 ? resources.getPropertyValue("ml.timeago.aboutayear.future") : this.handlePeriodKeyAsPlural(resources, "ml.timeago.aboutamonth.future", periodKey, months1);
                        timeAgo.append(yMonthsText);
                        break;
                    }
                    case 10: {
                        int years1 = Math.abs(Math.round((float)dim / 525600.0f));
                        timeAgo.append(resources.getPropertyValue(periodKey, years1));
                        break;
                    }
                    default: {
                        timeAgo.append(resources.getPropertyValue(periodKey));
                    }
                }
            }
            return timeAgo;
        }

        private final String handlePeriodKeyAsPlural(TimeAgoMessages resources, String periodKey, String pluralKey, int value) {
            return value == 1 ? resources.getPropertyValue(periodKey) : resources.getPropertyValue(pluralKey, value);
        }

        private final long getTimeDistanceInMinutes(long time) {
            long timeDistance = System.currentTimeMillis() - time;
            return Math.round(timeDistance / (long)1000 / (long)60);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

