/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.example;

import java.util.Locale;
import org.simmetrics.MultisetDistance;
import org.simmetrics.MultisetMetric;
import org.simmetrics.StringDistance;
import org.simmetrics.StringMetric;
import org.simmetrics.builders.StringDistanceBuilder;
import org.simmetrics.builders.StringMetricBuilder;
import org.simmetrics.metrics.CosineSimilarity;
import org.simmetrics.metrics.EuclideanDistance;
import org.simmetrics.metrics.StringMetrics;
import org.simmetrics.simplifiers.Simplifiers;
import org.simmetrics.tokenizers.Tokenizers;

public final class ReadMeExample {
    public static float example01() {
        String str1 = "This is a sentence. It is made of words";
        String str2 = "This sentence is similar. It has almost the same words";
        StringMetric metric = StringMetrics.cosineSimilarity();
        float result = metric.compare(str1, str2);
        return result;
    }

    public static float example02() {
        String str1 = "This is a sentence. It is made of words";
        String str2 = "This sentence is similar. It has almost the same words";
        StringMetric metric = StringMetricBuilder.with((MultisetMetric)new CosineSimilarity()).simplify(Simplifiers.toLowerCase((Locale)Locale.ENGLISH)).simplify(Simplifiers.replaceNonWord()).tokenize(Tokenizers.whitespace()).build();
        float result = metric.compare(str1, str2);
        return result;
    }

    public static float example03() {
        String str1 = "This is a sentence. It is made of words";
        String str2 = "This sentence is similar. It has almost the same words";
        StringDistance metric = StringDistanceBuilder.with((MultisetDistance)new EuclideanDistance()).simplify(Simplifiers.toLowerCase((Locale)Locale.ENGLISH)).simplify(Simplifiers.replaceNonWord()).tokenize(Tokenizers.whitespace()).build();
        float result = metric.distance(str1, str2);
        return result;
    }
}

