/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.example;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.simmetrics.MultisetMetric;
import org.simmetrics.StringMetric;
import org.simmetrics.builders.StringMetricBuilder;
import org.simmetrics.metrics.CosineSimilarity;
import org.simmetrics.metrics.Levenshtein;
import org.simmetrics.simplifiers.Simplifiers;
import org.simmetrics.tokenizers.Tokenizers;

public final class StringMetricBuilderExample {
    public static float example00() {
        String a = "Chilp\u00e9ric II son of Childeric II";
        String b = "chilperic ii son of childeric ii";
        Levenshtein metric = new Levenshtein();
        return metric.compare(a, b);
    }

    public static float example01() {
        String a = "Chilp\u00e9ric II son of Childeric II";
        String b = "Chilperic II son of Childeric II";
        StringMetric metric = StringMetricBuilder.with((StringMetric)new Levenshtein()).simplify(Simplifiers.removeDiacritics()).build();
        return metric.compare(a, b);
    }

    public static float example02() {
        String a = "Chilp\u00e9ric II son of Childeric II";
        String b = "chilperic ii son of childeric ii";
        StringMetric metric = StringMetricBuilder.with((StringMetric)new Levenshtein()).simplify(Simplifiers.removeDiacritics()).simplify(Simplifiers.toLowerCase()).build();
        return metric.compare(a, b);
    }

    public static float example03() {
        String a = "A quirky thing it is. This is a sentence.";
        String b = "This sentence is similar; a quirky thing it is.";
        StringMetric metric = StringMetricBuilder.with((MultisetMetric)new CosineSimilarity()).tokenize(Tokenizers.whitespace()).build();
        return metric.compare(a, b);
    }

    public static float example04() {
        String a = "A quirky thing it is. This is a sentence.";
        String b = "This sentence is similar; a quirky thing it is.";
        StringMetric metric = StringMetricBuilder.with((MultisetMetric)new CosineSimilarity()).tokenize(Tokenizers.whitespace()).tokenize(Tokenizers.qGram((int)3)).build();
        return metric.compare(a, b);
    }

    public static float example05() {
        HashSet commonWords = Sets.newHashSet((Object[])new String[]{"it", "is"});
        HashSet otherCommonWords = Sets.newHashSet((Object[])new String[]{"a"});
        String a = "A quirky thing it is. This is a sentence.";
        String b = "This sentence is similar; a quirky thing it is.";
        StringMetric metric = StringMetricBuilder.with((MultisetMetric)new CosineSimilarity()).simplify(Simplifiers.toLowerCase()).simplify(Simplifiers.removeNonWord()).tokenize(Tokenizers.whitespace()).filter(Predicates.not((Predicate)Predicates.in((Collection)commonWords))).filter(Predicates.not((Predicate)Predicates.in((Collection)otherCommonWords))).tokenize(Tokenizers.qGram((int)3)).build();
        return metric.compare(a, b);
    }

    public static float example06() {
        Function<String, String> reverse = new Function<String, String>(){

            public String apply(String input) {
                return new StringBuilder(input).reverse().toString();
            }
        };
        String a = "A quirky thing it is. This is a sentence.";
        String b = "This sentence is similar; a quirky thing it is.";
        StringMetric metric = StringMetricBuilder.with((MultisetMetric)new CosineSimilarity()).simplify(Simplifiers.toLowerCase()).simplify(Simplifiers.removeNonWord()).tokenize(Tokenizers.whitespace()).transform((Function)reverse).tokenize(Tokenizers.qGram((int)3)).build();
        return metric.compare(a, b);
    }

    public static float example07() {
        String a = "A quirky thing it is. This is a sentence.";
        String b = "This sentence is similar; a quirky thing it is.";
        Cache stringCache = CacheBuilder.newBuilder().maximumSize(2L).build();
        Cache tokenCache = CacheBuilder.newBuilder().maximumSize(2L).build();
        StringMetric metric = StringMetricBuilder.with((MultisetMetric)new CosineSimilarity()).simplify(Simplifiers.toLowerCase()).simplify(Simplifiers.removeNonWord()).cacheStrings(stringCache).tokenize(Tokenizers.qGram((int)3)).cacheTokens(tokenCache).build();
        return metric.compare(a, b);
    }
}

