/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import net.sourceforge.pinyin4j.ChineseToPinyinResource;
import net.sourceforge.pinyin4j.GwoyeuRomatzyhTranslator;
import net.sourceforge.pinyin4j.PinyinFormatter;
import net.sourceforge.pinyin4j.PinyinRomanizationTranslator;
import net.sourceforge.pinyin4j.PinyinRomanizationType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import net.sourceforge.pinyin4j.multipinyin.Trie;

public class PinyinHelper {
    private static final String[] ARR_EMPTY = new String[0];
    private static final String EMPTY = "";

    public static String[] toHanyuPinyinStringArray(char ch) {
        return PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
    }

    public static String[] toHanyuPinyinStringArray(char ch, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.getFormattedHanyuPinyinStringArray(ch, outputFormat);
    }

    private static String[] getFormattedHanyuPinyinStringArray(char ch, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        String[] pinyinStrArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != pinyinStrArray) {
            for (int i = 0; i < pinyinStrArray.length; ++i) {
                pinyinStrArray[i] = PinyinFormatter.formatHanyuPinyin(pinyinStrArray[i], outputFormat);
            }
            return pinyinStrArray;
        }
        return ARR_EMPTY;
    }

    private static String[] getUnformattedHanyuPinyinStringArray(char ch) {
        return ChineseToPinyinResource.getInstance().getHanyuPinyinStringArray(ch);
    }

    public static String[] toTongyongPinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.TONGYONG_PINYIN);
    }

    public static String[] toWadeGilesPinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.WADEGILES_PINYIN);
    }

    public static String[] toMPS2PinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.MPS2_PINYIN);
    }

    public static String[] toYalePinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.YALE_PINYIN);
    }

    private static String[] convertToTargetPinyinStringArray(char ch, PinyinRomanizationType targetPinyinSystem) {
        String[] hanyuPinyinStringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != hanyuPinyinStringArray) {
            String[] targetPinyinStringArray = new String[hanyuPinyinStringArray.length];
            for (int i = 0; i < hanyuPinyinStringArray.length; ++i) {
                targetPinyinStringArray[i] = PinyinRomanizationTranslator.convertRomanizationSystem(hanyuPinyinStringArray[i], PinyinRomanizationType.HANYU_PINYIN, targetPinyinSystem);
            }
            return targetPinyinStringArray;
        }
        return ARR_EMPTY;
    }

    public static String[] toGwoyeuRomatzyhStringArray(char ch) {
        return PinyinHelper.convertToGwoyeuRomatzyhStringArray(ch);
    }

    private static String[] convertToGwoyeuRomatzyhStringArray(char ch) {
        String[] hanyuPinyinStringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != hanyuPinyinStringArray) {
            String[] targetPinyinStringArray = new String[hanyuPinyinStringArray.length];
            for (int i = 0; i < hanyuPinyinStringArray.length; ++i) {
                targetPinyinStringArray[i] = GwoyeuRomatzyhTranslator.convertHanyuPinyinToGwoyeuRomatzyh(hanyuPinyinStringArray[i]);
            }
            return targetPinyinStringArray;
        }
        return ARR_EMPTY;
    }

    public static String toHanYuPinyinString(String str, HanyuPinyinOutputFormat outputFormat, String separate, boolean retain, boolean firstLetter) throws BadHanyuPinyinOutputFormatCombination {
        if (separate == null) {
            separate = EMPTY;
        }
        ChineseToPinyinResource resource = ChineseToPinyinResource.getInstance();
        StringBuilder resultPinyinStrBuf = new StringBuilder();
        if (str == null || (str = str.trim()).length() == 0) {
            return EMPTY;
        }
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            String result = null;
            char ch = chars[i];
            Trie currentTrie = resource.getUnicodeToHanyuPinyinTable();
            int success = i;
            int current = i;
            do {
                String hexStr;
                if ((currentTrie = currentTrie.get(hexStr = Integer.toHexString(ch).toUpperCase())) != null) {
                    if (currentTrie.getPinyin() != null) {
                        result = currentTrie.getPinyin();
                        success = current;
                    }
                    currentTrie = currentTrie.getNextTire();
                }
                if (++current >= chars.length) break;
                ch = chars[current];
            } while (currentTrie != null);
            if (result == null) {
                if (retain) {
                    resultPinyinStrBuf.append(chars[i]);
                }
                resultPinyinStrBuf.append(separate);
            } else {
                String[] pinyinStrArray = resource.parsePinyinString(result);
                if (pinyinStrArray != null) {
                    for (String aPinyinStrArray : pinyinStrArray) {
                        aPinyinStrArray = PinyinFormatter.formatHanyuPinyin(aPinyinStrArray, outputFormat);
                        resultPinyinStrBuf.append(firstLetter ? Character.valueOf(aPinyinStrArray.charAt(0)) : aPinyinStrArray);
                        resultPinyinStrBuf.append(separate);
                        if (i == success) break;
                    }
                }
            }
            i = success;
        }
        resultPinyinStrBuf.setLength(resultPinyinStrBuf.length() - separate.length());
        return resultPinyinStrBuf.toString();
    }

    public static String toHanYuPinyinStringFirstLetter(String str, HanyuPinyinOutputFormat outputFormat, String separate, boolean retain) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.toHanYuPinyinString(str, outputFormat, separate, retain, true);
    }

    public static String toHanYuPinyinString(String str, HanyuPinyinOutputFormat outputFormat, String separate, boolean retain) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.toHanYuPinyinString(str, outputFormat, separate, retain, false);
    }

    public static boolean isEnglishLetter(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c);
    }

    private PinyinHelper() {
    }
}

