/*
 * Decompiled with CFR 0.152.
 */
package com.github.ptgoetz.logback.kafka.formatter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.github.ptgoetz.logback.kafka.formatter.Formatter;

public class JsonFormatter
implements Formatter {
    private static final String QUOTE = "\"";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private boolean expectJson = false;

    public String format(ILoggingEvent event) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        JsonFormatter.fieldName("level", sb);
        JsonFormatter.quote(event.getLevel().levelStr, sb);
        sb.append(COMMA);
        JsonFormatter.fieldName("logger", sb);
        JsonFormatter.quote(event.getLoggerName(), sb);
        sb.append(COMMA);
        JsonFormatter.fieldName("timestamp", sb);
        sb.append(event.getTimeStamp());
        sb.append(COMMA);
        JsonFormatter.fieldName("message", sb);
        if (this.expectJson) {
            sb.append(event.getFormattedMessage());
        } else {
            JsonFormatter.quote(event.getFormattedMessage(), sb);
        }
        sb.append("}");
        return sb.toString();
    }

    private static void fieldName(String name, StringBuilder sb) {
        JsonFormatter.quote(name, sb);
        sb.append(COLON);
    }

    private static void quote(String value, StringBuilder sb) {
        sb.append(QUOTE);
        sb.append(value);
        sb.append(QUOTE);
    }

    public boolean isExpectJson() {
        return this.expectJson;
    }

    public void setExpectJson(boolean expectJson) {
        this.expectJson = expectJson;
    }
}

