/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.memory;

import com.github.robtimus.filesystems.Messages;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;

final class CopyOptions {
    public final boolean replaceExisting;
    public final boolean copyAttributes;
    public final boolean followLinks;

    private CopyOptions(boolean replaceExisting, boolean copyAttributes, boolean followLinks) {
        this.replaceExisting = replaceExisting;
        this.copyAttributes = copyAttributes;
        this.followLinks = followLinks;
    }

    static CopyOptions forCopy(CopyOption ... options) {
        boolean replaceExisting = false;
        boolean copyAttributes = false;
        boolean followLinks = true;
        for (CopyOption option : options) {
            if (option == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (option == StandardCopyOption.COPY_ATTRIBUTES) {
                copyAttributes = true;
                continue;
            }
            if (option == LinkOption.NOFOLLOW_LINKS) {
                followLinks = false;
                continue;
            }
            if (CopyOptions.isIgnoredCopyOption(option)) continue;
            throw Messages.fileSystemProvider().unsupportedCopyOption(option);
        }
        return new CopyOptions(replaceExisting, copyAttributes, followLinks);
    }

    static CopyOptions forMove(CopyOption ... options) {
        boolean replaceExisting = false;
        boolean followLinks = true;
        for (CopyOption option : options) {
            if (option == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (option == LinkOption.NOFOLLOW_LINKS) {
                followLinks = false;
                continue;
            }
            if (CopyOptions.isIgnoredCopyOption(option)) continue;
            throw Messages.fileSystemProvider().unsupportedCopyOption(option);
        }
        return new CopyOptions(replaceExisting, false, followLinks);
    }

    private static boolean isIgnoredCopyOption(CopyOption option) {
        return option == StandardCopyOption.ATOMIC_MOVE;
    }
}

