/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.memory;

import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.PathMatcherSupport;
import com.github.robtimus.filesystems.memory.MemoryFileAttributes;
import com.github.robtimus.filesystems.memory.MemoryFileStore;
import com.github.robtimus.filesystems.memory.MemoryFileSystemProvider;
import com.github.robtimus.filesystems.memory.MemoryPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

final class MemoryFileSystem
extends FileSystem {
    private static final Set<String> SUPPORTED_FILE_ATTRIBUTE_VIEWS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "memory")));
    private final FileSystemProvider provider;
    private final Iterable<Path> rootDirectories;
    private final MemoryFileStore fileStore;
    private final Iterable<FileStore> fileStores;

    MemoryFileSystem(MemoryFileSystemProvider provider, MemoryFileStore fileStore) {
        this.provider = Objects.requireNonNull(provider);
        this.rootDirectories = Collections.singleton(new MemoryPath(this, "/"));
        this.fileStore = Objects.requireNonNull(fileStore);
        this.fileStores = Collections.singleton(fileStore);
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return this.rootDirectories;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.fileStores;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SUPPORTED_FILE_ATTRIBUTE_VIEWS;
    }

    @Override
    public Path getPath(String first, String ... more) {
        StringBuilder sb = new StringBuilder(first);
        for (String s : more) {
            sb.append("/").append(s);
        }
        return new MemoryPath(this, sb.toString());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        Pattern pattern = PathMatcherSupport.toPattern((String)syntaxAndPattern);
        return path -> pattern.matcher(path.toString()).matches();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw Messages.unsupportedOperation(FileSystem.class, (String)"getUserPrincipalLookupService");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw Messages.unsupportedOperation(FileSystem.class, (String)"newWatchService");
    }

    URI toUri(MemoryPath path) {
        return URI.create("memory:" + (Object)((Object)this.toAbsolutePath(path).normalize()));
    }

    MemoryPath toAbsolutePath(MemoryPath path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new MemoryPath(this, "/" + path.path());
    }

    MemoryPath toRealPath(MemoryPath path, boolean followLinks) throws IOException {
        return this.fileStore.toRealPath(path, followLinks);
    }

    String toString(MemoryPath path) {
        return path.path();
    }

    byte[] getContent(MemoryPath path) throws IOException {
        return this.fileStore.getContent(path);
    }

    void setContent(MemoryPath path, byte[] content) throws IOException {
        this.fileStore.setContent(path, content);
    }

    InputStream newInputStream(MemoryPath path, OpenOption ... options) throws IOException {
        return this.fileStore.newInputStream(path, options);
    }

    OutputStream newOutputStream(MemoryPath path, OpenOption ... options) throws IOException {
        return this.fileStore.newOutputStream(path, options);
    }

    FileChannel newFileChannel(MemoryPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.fileStore.newFileChannel(path, options, attrs);
    }

    SeekableByteChannel newByteChannel(MemoryPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.fileStore.newByteChannel(path, options, attrs);
    }

    DirectoryStream<Path> newDirectoryStream(MemoryPath dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fileStore.newDirectoryStream(dir, filter);
    }

    void createDirectory(MemoryPath dir, FileAttribute<?> ... attrs) throws IOException {
        this.fileStore.createDirectory(dir, attrs);
    }

    void createSymbolicLink(MemoryPath link, MemoryPath target, FileAttribute<?> ... attrs) throws IOException {
        this.fileStore.createSymbolicLink(link, target, attrs);
    }

    void createLink(MemoryPath link, MemoryPath existing) throws IOException {
        this.fileStore.createLink(link, existing);
    }

    void delete(MemoryPath path) throws IOException {
        this.fileStore.delete(path);
    }

    boolean deleteIfExists(MemoryPath path) throws IOException {
        return this.fileStore.deleteIfExists(path);
    }

    MemoryPath readSymbolicLink(MemoryPath link) throws IOException {
        return this.fileStore.readSymbolicLink(link);
    }

    void copy(MemoryPath source, MemoryPath target, CopyOption ... options) throws IOException {
        this.fileStore.copy(source, target, options);
    }

    void move(MemoryPath source, MemoryPath target, CopyOption ... options) throws IOException {
        this.fileStore.move(source, target, options);
    }

    boolean isSameFile(MemoryPath path, MemoryPath path2) throws IOException {
        return this.fileStore.isSameFile(path, path2);
    }

    boolean isHidden(MemoryPath path) throws IOException {
        return this.fileStore.isHidden(path);
    }

    FileStore getFileStore(MemoryPath path) throws IOException {
        return this.fileStore.getFileStore(path);
    }

    void checkAccess(MemoryPath path, AccessMode ... modes) throws IOException {
        this.fileStore.checkAccess(path, modes);
    }

    void setTimes(MemoryPath path, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime, boolean followLinks) throws IOException {
        this.fileStore.setTimes(path, lastModifiedTime, lastAccessTime, createTime, followLinks);
    }

    MemoryFileAttributes readAttributes(MemoryPath path, boolean followLinks) throws IOException {
        return this.fileStore.readAttributes(path, followLinks);
    }

    void setReadOnly(MemoryPath path, boolean value, boolean followLinks) throws IOException {
        this.fileStore.setReadOnly(path, value, followLinks);
    }

    void setHidden(MemoryPath path, boolean value, boolean followLinks) throws IOException {
        this.fileStore.setHidden(path, value, followLinks);
    }

    Map<String, Object> readAttributes(MemoryPath path, String attributes, boolean followLinks) throws IOException {
        return this.fileStore.readAttributes(path, attributes, followLinks);
    }

    void setAttribute(MemoryPath path, String attribute, Object value, boolean followLinks) throws IOException {
        this.fileStore.setAttribute(path, attribute, value, followLinks);
    }
}

