/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.memory;

import com.github.robtimus.filesystems.LinkOptionSupport;
import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.memory.MemoryFileAttributeView;
import com.github.robtimus.filesystems.memory.MemoryFileAttributes;
import com.github.robtimus.filesystems.memory.MemoryFileStore;
import com.github.robtimus.filesystems.memory.MemoryFileSystem;
import com.github.robtimus.filesystems.memory.MemoryPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class MemoryFileSystemProvider
extends FileSystemProvider {
    private final MemoryFileSystem fs;

    public MemoryFileSystemProvider() {
        this(MemoryFileStore.INSTANCE);
    }

    MemoryFileSystemProvider(MemoryFileStore fileStore) {
        this.fs = new MemoryFileSystem(this, fileStore);
    }

    @Override
    public String getScheme() {
        return "memory";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        this.checkURI(uri);
        throw new FileSystemAlreadyExistsException();
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        this.checkURI(uri);
        return this.fs;
    }

    @Override
    public Path getPath(URI uri) {
        this.checkURI(uri);
        return this.fs.getPath(uri.getSchemeSpecificPart(), new String[0]);
    }

    private void checkURI(URI uri) {
        if (!uri.isAbsolute()) {
            throw Messages.uri().notAbsolute(uri);
        }
        if (!this.getScheme().equalsIgnoreCase(uri.getScheme())) {
            throw Messages.uri().invalidScheme(uri, this.getScheme());
        }
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).newOutputStream(options);
    }

    @Override
    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).newFileChannel(options, attrs);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).newByteChannel(options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(dir).newDirectoryStream(filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        MemoryFileSystemProvider.toMemoryPath(dir).createDirectory(attrs);
    }

    @Override
    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
        MemoryFileSystemProvider.toMemoryPath(link).createSymbolicLink(MemoryFileSystemProvider.toMemoryPath(target), attrs);
    }

    @Override
    public void createLink(Path link, Path existing) throws IOException {
        MemoryFileSystemProvider.toMemoryPath(link).createLink(MemoryFileSystemProvider.toMemoryPath(existing));
    }

    @Override
    public void delete(Path path) throws IOException {
        MemoryFileSystemProvider.toMemoryPath(path).delete();
    }

    @Override
    public boolean deleteIfExists(Path path) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).deleteIfExists();
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(link).readSymbolicLink();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        MemoryFileSystemProvider.toMemoryPath(source).copy(MemoryFileSystemProvider.toMemoryPath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        MemoryFileSystemProvider.toMemoryPath(source).move(MemoryFileSystemProvider.toMemoryPath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).isSameFile(path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).getFileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        MemoryFileSystemProvider.toMemoryPath(path).checkAccess(modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Objects.requireNonNull(type);
        if (type == BasicFileAttributeView.class) {
            boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
            return (V)((FileAttributeView)type.cast(new AttributeView("basic", MemoryFileSystemProvider.toMemoryPath(path), followLinks)));
        }
        if (type == MemoryFileAttributeView.class) {
            boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
            return (V)((FileAttributeView)type.cast(new AttributeView("memory", MemoryFileSystemProvider.toMemoryPath(path), followLinks)));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == MemoryFileAttributes.class) {
            boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
            return (A)((BasicFileAttributes)type.cast(MemoryFileSystemProvider.toMemoryPath(path).readAttributes(followLinks)));
        }
        throw Messages.fileSystemProvider().unsupportedFileAttributesType(type);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
        return MemoryFileSystemProvider.toMemoryPath(path).readAttributes(attributes, followLinks);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
        MemoryFileSystemProvider.toMemoryPath(path).setAttribute(attribute, value, followLinks);
    }

    public static byte[] getContent(String path) throws IOException {
        Objects.requireNonNull(path);
        URI uri = URI.create("memory:" + path);
        return MemoryFileSystemProvider.getContent(Paths.get(uri));
    }

    public static byte[] getContent(Path path) throws IOException {
        return MemoryFileSystemProvider.toMemoryPath(path).getContent();
    }

    public static void setContent(String path, byte[] content) throws IOException {
        Objects.requireNonNull(path);
        URI uri = URI.create("memory:" + path);
        MemoryFileSystemProvider.setContent(Paths.get(uri), content);
    }

    public static void setContent(Path path, byte[] content) throws IOException {
        Objects.requireNonNull(content);
        MemoryFileSystemProvider.toMemoryPath(path).setContent(content);
    }

    private static MemoryPath toMemoryPath(Path path) {
        Objects.requireNonNull(path);
        if (path instanceof MemoryPath) {
            return (MemoryPath)((Object)path);
        }
        throw new ProviderMismatchException();
    }

    public static void clear() {
        MemoryFileStore.INSTANCE.clear();
    }

    private static final class AttributeView
    implements MemoryFileAttributeView {
        private final String name;
        private final MemoryPath path;
        private final boolean followLinks;

        private AttributeView(String name, MemoryPath path, boolean followLinks) {
            this.name = Objects.requireNonNull(name);
            this.path = Objects.requireNonNull(path);
            this.followLinks = followLinks;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            this.path.setTimes(lastModifiedTime, lastAccessTime, createTime, this.followLinks);
        }

        @Override
        public MemoryFileAttributes readAttributes() throws IOException {
            return this.path.readAttributes(this.followLinks);
        }

        @Override
        public void setReadOnly(boolean value) throws IOException {
            this.path.setReadOnly(value, this.followLinks);
        }

        @Override
        public void setHidden(boolean value) throws IOException {
            this.path.setHidden(value, this.followLinks);
        }
    }
}

