/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.memory;

import com.github.robtimus.filesystems.LinkOptionSupport;
import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.SimpleAbstractPath;
import com.github.robtimus.filesystems.memory.MemoryFileAttributes;
import com.github.robtimus.filesystems.memory.MemoryFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class MemoryPath
extends SimpleAbstractPath {
    private final MemoryFileSystem fs;

    MemoryPath(MemoryFileSystem fs, String path) {
        super(path);
        this.fs = Objects.requireNonNull(fs);
    }

    private MemoryPath(MemoryFileSystem fs, String path, boolean normalized) {
        super(path, normalized);
        this.fs = Objects.requireNonNull(fs);
    }

    protected MemoryPath createPath(String path) {
        return new MemoryPath(this.fs, path, true);
    }

    public MemoryFileSystem getFileSystem() {
        return this.fs;
    }

    public MemoryPath getRoot() {
        return (MemoryPath)((Object)super.getRoot());
    }

    public MemoryPath getFileName() {
        return (MemoryPath)((Object)super.getFileName());
    }

    public MemoryPath getParent() {
        return (MemoryPath)((Object)super.getParent());
    }

    public MemoryPath getName(int index) {
        return (MemoryPath)((Object)super.getName(index));
    }

    public MemoryPath subpath(int beginIndex, int endIndex) {
        return (MemoryPath)((Object)super.subpath(beginIndex, endIndex));
    }

    public MemoryPath normalize() {
        return (MemoryPath)((Object)super.normalize());
    }

    public MemoryPath resolve(Path other) {
        return (MemoryPath)((Object)super.resolve(other));
    }

    public MemoryPath resolve(String other) {
        return (MemoryPath)((Object)super.resolve(other));
    }

    public MemoryPath resolveSibling(Path other) {
        return (MemoryPath)((Object)super.resolveSibling(other));
    }

    public MemoryPath resolveSibling(String other) {
        return (MemoryPath)((Object)super.resolveSibling(other));
    }

    public MemoryPath relativize(Path other) {
        return (MemoryPath)((Object)super.relativize(other));
    }

    public URI toUri() {
        return URI.create((this.isAbsolute() ? "memory:" : "memory:/") + this.path());
    }

    public MemoryPath toAbsolutePath() {
        return this.fs.toAbsolutePath(this);
    }

    public MemoryPath toRealPath(LinkOption ... options) throws IOException {
        boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
        return this.fs.toRealPath(this, followLinks);
    }

    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw Messages.unsupportedOperation(Path.class, (String)"register");
    }

    public String toString() {
        return this.fs.toString(this);
    }

    byte[] getContent() throws IOException {
        return this.fs.getContent(this);
    }

    void setContent(byte[] content) throws IOException {
        this.fs.setContent(this, content);
    }

    InputStream newInputStream(OpenOption ... options) throws IOException {
        return this.fs.newInputStream(this, options);
    }

    OutputStream newOutputStream(OpenOption ... options) throws IOException {
        return this.fs.newOutputStream(this, options);
    }

    FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.fs.newFileChannel(this, options, attrs);
    }

    SeekableByteChannel newByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.fs.newByteChannel(this, options, attrs);
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fs.newDirectoryStream(this, filter);
    }

    void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.fs.createDirectory(this, attrs);
    }

    void createSymbolicLink(MemoryPath target, FileAttribute<?> ... attrs) throws IOException {
        this.fs.createSymbolicLink(this, target, attrs);
    }

    void createLink(MemoryPath existing) throws IOException {
        this.fs.createLink(this, existing);
    }

    void delete() throws IOException {
        this.fs.delete(this);
    }

    boolean deleteIfExists() throws IOException {
        return this.fs.deleteIfExists(this);
    }

    MemoryPath readSymbolicLink() throws IOException {
        return this.fs.readSymbolicLink(this);
    }

    void copy(MemoryPath target, CopyOption ... options) throws IOException {
        this.fs.copy(this, target, options);
    }

    void move(MemoryPath target, CopyOption ... options) throws IOException {
        this.fs.move(this, target, options);
    }

    boolean isSameFile(Path other) throws IOException {
        if (this.equals(other)) {
            return true;
        }
        if (other == null || this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        return this.fs.isSameFile(this, (MemoryPath)((Object)other));
    }

    boolean isHidden() throws IOException {
        return this.fs.isHidden(this);
    }

    FileStore getFileStore() throws IOException {
        return this.fs.getFileStore(this);
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        this.fs.checkAccess(this, modes);
    }

    void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime, boolean followLinks) throws IOException {
        this.fs.setTimes(this, lastModifiedTime, lastAccessTime, createTime, followLinks);
    }

    MemoryFileAttributes readAttributes(boolean followLinks) throws IOException {
        return this.fs.readAttributes(this, followLinks);
    }

    void setReadOnly(boolean value, boolean followLinks) throws IOException {
        this.fs.setReadOnly(this, value, followLinks);
    }

    void setHidden(boolean value, boolean followLinks) throws IOException {
        this.fs.setHidden(this, value, followLinks);
    }

    Map<String, Object> readAttributes(String attributes, boolean followLinks) throws IOException {
        return this.fs.readAttributes(this, attributes, followLinks);
    }

    void setAttribute(String attribute, Object value, boolean followLinks) throws IOException {
        this.fs.setAttribute(this, attribute, value, followLinks);
    }
}

