/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.memory;

import com.github.robtimus.filesystems.Messages;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;

final class OpenOptions {
    public final boolean read;
    public final boolean write;
    public final boolean append;
    public final boolean create;
    public final boolean createNew;
    public final boolean deleteOnClose;

    private OpenOptions(boolean read, boolean write, boolean append, boolean create, boolean createNew, boolean deleteOnClose) {
        this.read = read;
        this.write = write;
        this.append = append;
        this.create = create;
        this.createNew = createNew;
        this.deleteOnClose = deleteOnClose;
    }

    static OpenOptions forNewInputStream(OpenOption ... options) {
        if (options.length == 0) {
            return new OpenOptions(true, false, false, false, false, false);
        }
        boolean deleteOnClose = false;
        for (OpenOption option : options) {
            if (option == StandardOpenOption.DELETE_ON_CLOSE) {
                deleteOnClose = true;
                continue;
            }
            if (option == StandardOpenOption.READ || OpenOptions.isIgnoredOpenOption(option)) continue;
            throw Messages.fileSystemProvider().unsupportedOpenOption(option);
        }
        return new OpenOptions(true, false, false, false, false, deleteOnClose);
    }

    static OpenOptions forNewOutputStream(OpenOption ... options) {
        if (options.length == 0) {
            return new OpenOptions(false, true, false, true, false, false);
        }
        boolean append = false;
        boolean truncateExisting = false;
        boolean create = false;
        boolean createNew = false;
        boolean deleteOnClose = false;
        for (OpenOption option : options) {
            if (option == StandardOpenOption.APPEND) {
                append = true;
                continue;
            }
            if (option == StandardOpenOption.TRUNCATE_EXISTING) {
                truncateExisting = true;
                continue;
            }
            if (option == StandardOpenOption.CREATE) {
                create = true;
                continue;
            }
            if (option == StandardOpenOption.CREATE_NEW) {
                createNew = true;
                continue;
            }
            if (option == StandardOpenOption.DELETE_ON_CLOSE) {
                deleteOnClose = true;
                continue;
            }
            if (option == StandardOpenOption.WRITE || OpenOptions.isIgnoredOpenOption(option)) continue;
            throw Messages.fileSystemProvider().unsupportedOpenOption(option);
        }
        if (append && truncateExisting) {
            throw Messages.fileSystemProvider().illegalOpenOptionCombination(options);
        }
        return new OpenOptions(false, true, append, create, createNew, deleteOnClose);
    }

    static OpenOptions forNewFileChannel(Set<? extends OpenOption> options) {
        boolean read = false;
        boolean write = false;
        boolean append = false;
        boolean truncateExisting = false;
        boolean create = false;
        boolean createNew = false;
        boolean deleteOnClose = false;
        for (OpenOption openOption : options) {
            if (openOption == StandardOpenOption.READ) {
                read = true;
                continue;
            }
            if (openOption == StandardOpenOption.WRITE) {
                write = true;
                continue;
            }
            if (openOption == StandardOpenOption.APPEND) {
                append = true;
                continue;
            }
            if (openOption == StandardOpenOption.TRUNCATE_EXISTING) {
                truncateExisting = true;
                continue;
            }
            if (openOption == StandardOpenOption.CREATE) {
                create = true;
                continue;
            }
            if (openOption == StandardOpenOption.CREATE_NEW) {
                createNew = true;
                continue;
            }
            if (openOption == StandardOpenOption.DELETE_ON_CLOSE) {
                deleteOnClose = true;
                continue;
            }
            if (OpenOptions.isIgnoredOpenOption(openOption)) continue;
            throw Messages.fileSystemProvider().unsupportedOpenOption(openOption);
        }
        if (!(read || write || append)) {
            read = true;
        }
        if (append && (read || truncateExisting)) {
            throw Messages.fileSystemProvider().illegalOpenOptionCombination(options);
        }
        if (append) {
            write = true;
        }
        return new OpenOptions(read, write, append, create, createNew, deleteOnClose);
    }

    private static boolean isIgnoredOpenOption(OpenOption option) {
        return option == StandardOpenOption.SPARSE || option == StandardOpenOption.SYNC || option == StandardOpenOption.DSYNC || option == LinkOption.NOFOLLOW_LINKS;
    }
}

