/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.function;

import com.github.signaflo.math.Complex;
import com.github.signaflo.math.Real;
import com.github.signaflo.math.function.AbstractFunction;

public class QuadraticFunction
extends AbstractFunction {
    private final Real a;
    private final Real b;
    private final Real c;

    public QuadraticFunction(Real a, Real b, Real c) {
        if (a.asDouble() == 0.0) {
            throw new IllegalArgumentException("The first coefficient, a, cannot be zero.");
        }
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public QuadraticFunction(double a, double b, double c) {
        if (a == 0.0) {
            throw new IllegalArgumentException("The first coefficient, a, cannot be zero.");
        }
        this.a = Real.from(a);
        this.b = Real.from(b);
        this.c = Real.from(c);
    }

    public Complex[] zeros() {
        Real fourAC = this.a.times(this.c).times(4.0);
        Real bSquared = this.b.times(this.b);
        Complex root1 = this.b.additiveInverse().plus(bSquared.minus(fourAC).complexSqrt()).dividedBy(this.a.times(2.0).asDouble());
        Complex root2 = this.b.additiveInverse().minus(bSquared.minus(fourAC).complexSqrt()).dividedBy(this.a.times(2.0).asDouble());
        return new Complex[]{root1, root2};
    }

    public Real a() {
        return this.a;
    }

    public Real b() {
        return this.b;
    }

    public Real c() {
        return this.c;
    }

    public Real at(Real point) {
        return Real.from(this.at(point.asDouble()));
    }

    @Override
    public double at(double x) {
        return x * x * this.a.asDouble() + x * this.b.asDouble() + this.c.asDouble();
    }

    @Override
    public double slopeAt(double x) {
        return 2.0 * x * this.a.asDouble() + this.b.asDouble();
    }

    public Real[] coefficients() {
        return new Real[]{this.a, this.b, this.c};
    }

    public double[] coefficientsDbl() {
        return new double[]{this.a.asDouble(), this.b.asDouble(), this.c.asDouble()};
    }

    public double extremePointDbl() {
        return -this.b.asDouble() / (2.0 * this.a.asDouble());
    }

    public Real extremePoint() {
        return Real.from(-this.b.asDouble() / (2.0 * this.a.asDouble()));
    }

    public double extremumDbl() {
        double x = this.extremePointDbl();
        return this.a.asDouble() * x * x + this.b.asDouble() * x + this.c.asDouble();
    }

    public Real extremum() {
        double x = this.extremePoint().asDouble();
        return Real.from(this.a.asDouble() * x * x + this.b.asDouble() * x + this.c.asDouble());
    }

    public boolean hasMinimum() {
        return this.a.asDouble() > 0.0;
    }

    public boolean hasMaximum() {
        return this.a.asDouble() < 0.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuadraticFunction that = (QuadraticFunction)o;
        if (!this.a.equals(that.a)) {
            return false;
        }
        if (!this.b.equals(that.b)) {
            return false;
        }
        return this.c.equals(that.c);
    }

    public int hashCode() {
        int result = this.a.hashCode();
        result = 31 * result + this.b.hashCode();
        result = 31 * result + this.c.hashCode();
        return result;
    }

    public String toString() {
        return "f(x) = " + this.a.asDouble() + "x^2 + " + this.b.asDouble() + "x + " + this.c.asDouble();
    }
}

