/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.linear.doubles.Vector;
import com.github.signaflo.math.stats.Statistics;
import java.util.Arrays;

final class GenericVector
implements Vector {
    private final double[] elements;

    GenericVector(double ... elements) {
        this.elements = (double[])elements.clone();
    }

    @Override
    public double[] elements() {
        return (double[])this.elements.clone();
    }

    @Override
    public double at(int i) {
        return this.elements[i];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public GenericVector plus(Vector other) {
        if (other.elements().length == 0) {
            return this;
        }
        double[] summed = new double[this.size()];
        for (int i = 0; i < summed.length; ++i) {
            summed[i] = this.elements[i] + other.at(i);
        }
        return new GenericVector(summed);
    }

    @Override
    public GenericVector minus(Vector other) {
        double[] differenced = new double[this.size()];
        for (int i = 0; i < differenced.length; ++i) {
            differenced[i] = this.elements[i] - other.at(i);
        }
        return new GenericVector(differenced);
    }

    @Override
    public GenericVector minus(double scalar) {
        double[] differenced = new double[this.size()];
        for (int i = 0; i < differenced.length; ++i) {
            differenced[i] = this.elements[i] - scalar;
        }
        return new GenericVector(differenced);
    }

    @Override
    public GenericVector scaledBy(double alpha) {
        double[] scaled = new double[this.size()];
        for (int i = 0; i < scaled.length; ++i) {
            scaled[i] = alpha * this.elements[i];
        }
        return new GenericVector(scaled);
    }

    @Override
    public double dotProduct(Vector other) {
        if (other.elements().length == 0) {
            throw new IllegalArgumentException("The dot product is undefined for zero length vectors");
        }
        double product = 0.0;
        for (int i = 0; i < this.elements.length; ++i) {
            product += this.elements[i] * other.at(i);
        }
        return product;
    }

    @Override
    public Matrix outerProduct(Vector other) {
        double[] otherElements = other.elements();
        double[] product = new double[this.elements.length * otherElements.length];
        for (int i = 0; i < this.elements.length; ++i) {
            for (int j = 0; j < otherElements.length; ++j) {
                product[i * otherElements.length + j] = this.elements[i] * otherElements[j];
            }
        }
        return Matrix.create(this.elements.length, otherElements.length, product);
    }

    Vector axpy(GenericVector other, double alpha) {
        double[] result = new double[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = alpha * this.elements[i] + other.elements[i];
        }
        return new GenericVector(result);
    }

    @Override
    public double norm() {
        return Math.sqrt(this.dotProduct(this));
    }

    @Override
    public double sum() {
        return Statistics.sumOf(this.elements);
    }

    @Override
    public double sumOfSquares() {
        return Statistics.sumOfSquared(this.elements);
    }

    @Override
    public Vector push(double value) {
        double[] newElements = new double[this.elements.length + 1];
        newElements[0] = value;
        System.arraycopy(this.elements, 0, newElements, 1, this.elements.length);
        return new GenericVector(newElements);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.elements);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericVector other = (GenericVector)obj;
        return Arrays.equals(this.elements, other.elements);
    }

    public String toString() {
        return "elements: " + Arrays.toString(this.elements);
    }
}

