/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.ColumnMatrix;
import com.github.signaflo.math.linear.doubles.RowMatrix;
import com.github.signaflo.math.linear.doubles.Vector;
import java.util.ArrayList;
import java.util.List;

interface Matrix2 {
    public static RowBuilder rowBuilder() {
        return new RowBuilder();
    }

    public static ColumnBuilder columnBuilder() {
        return new ColumnBuilder();
    }

    public static RowBuilder rowBuilder(int nrow) {
        return new RowBuilder(nrow);
    }

    public static ColumnBuilder columnBuilder(int ncol) {
        return new ColumnBuilder(ncol);
    }

    public static Matrix2 fromRows(List<Vector> rowVectors) {
        return new RowMatrix(rowVectors);
    }

    public static Matrix2 fromColumns(List<Vector> columnVectors) {
        return new ColumnMatrix(columnVectors);
    }

    public static Matrix2 fromRows(double[] ... rowVectors) {
        ArrayList<Vector> rows = new ArrayList<Vector>(rowVectors.length);
        for (int i = 0; i < rowVectors.length; ++i) {
            rows.add(Vector.from(rowVectors[i]));
        }
        return new RowMatrix(rows);
    }

    public static Matrix2 fromColumns(double[] ... columnVectors) {
        ArrayList<Vector> columns = new ArrayList<Vector>(columnVectors.length);
        for (int i = 0; i < columnVectors.length; ++i) {
            columns.add(Vector.from(columnVectors[i]));
        }
        return new ColumnMatrix(columns);
    }

    public List<Vector> getRows();

    public List<Vector> getColumns();

    public int nrow();

    public int ncol();

    public Matrix2 times(Matrix2 var1);

    public Vector times(Vector var1);

    public static class ColumnBuilder {
        private List<Vector> columns;

        private ColumnBuilder() {
            this.columns = new ArrayList<Vector>();
        }

        private ColumnBuilder(int ncol) {
            this.columns = new ArrayList<Vector>(ncol);
        }

        ColumnBuilder addColumn(Vector vector) {
            this.columns.add(vector);
            return this;
        }

        ColumnBuilder setColumn(int j, Vector vector) {
            this.columns.set(j, vector);
            return this;
        }

        ColumnBuilder addColumn(double ... vector) {
            this.columns.add(Vector.from(vector));
            return this;
        }

        ColumnBuilder setColumn(int j, double ... vector) {
            this.columns.set(j, Vector.from(vector));
            return this;
        }

        Matrix2 build() {
            return new ColumnMatrix(this.columns);
        }
    }

    public static class RowBuilder {
        private List<Vector> rows;

        private RowBuilder() {
            this.rows = new ArrayList<Vector>();
        }

        private RowBuilder(int nrow) {
            this.rows = new ArrayList<Vector>(nrow);
        }

        RowBuilder addRow(Vector vector) {
            this.rows.add(vector);
            return this;
        }

        RowBuilder addRow(double ... vector) {
            this.rows.add(Vector.from(vector));
            return this;
        }

        RowBuilder setRow(int i, double ... vector) {
            this.rows.set(i, Vector.from(vector));
            return this;
        }

        RowBuilder setRow(int i, Vector vector) {
            this.rows.set(i, vector);
            return this;
        }

        Matrix2 build() {
            return new RowMatrix(this.rows);
        }
    }
}

