/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import java.util.Arrays;

class MutableMatrix {
    private final int nrow;
    private final int ncol;
    private final double[] data;
    private final int[] rowIndices;

    MutableMatrix(int nrow, int ncol, double ... data) {
        this.nrow = nrow;
        this.ncol = ncol;
        this.data = (double[])data.clone();
        this.rowIndices = new int[nrow];
        for (int i = 0; i < this.nrow; ++i) {
            this.rowIndices[i] = i * ncol;
        }
    }

    double get(int i, int j) {
        return this.data[this.rowIndices[i] + j];
    }

    double[] getRow(int i) {
        double[] row = new double[this.ncol];
        System.arraycopy(this.data, this.rowIndices[i], row, 0, row.length);
        return row;
    }

    double[] getColumn(int j) {
        double[] column = new double[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            column[i] = this.data[this.rowIndices[i] + j];
        }
        return column;
    }

    void swapRows(int i, int j) {
        int temp = this.rowIndices[i];
        this.rowIndices[i] = this.rowIndices[j];
        this.rowIndices[j] = temp;
    }

    void scaleRow(int i, double alpha) {
        for (int j = 0; j < this.ncol; ++j) {
            int n = this.rowIndices[i] + j;
            this.data[n] = this.data[n] * alpha;
        }
    }

    double[] scaleAndReturnRow(int i, double alpha) {
        double[] row = new double[this.ncol];
        for (int j = 0; j < this.ncol; ++j) {
            row[j] = this.data[this.rowIndices[i] + j] * alpha;
        }
        return row;
    }

    void addRow(double[] row, int i) {
        for (int j = 0; j < this.ncol; ++j) {
            int n = this.rowIndices[i] + j;
            this.data[n] = this.data[n] + row[j];
        }
    }

    void scaleAndAddRow(int i, int j, double alpha) {
        double[] scaledRow = this.scaleAndReturnRow(i, alpha);
        this.addRow(scaledRow, j);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableMatrix)) {
            return false;
        }
        MutableMatrix other = (MutableMatrix)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nrow != other.nrow) {
            return false;
        }
        if (this.ncol != other.ncol) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return Arrays.equals(this.rowIndices, other.rowIndices);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MutableMatrix;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.nrow;
        result = result * 59 + this.ncol;
        result = result * 59 + Arrays.hashCode(this.data);
        result = result * 59 + Arrays.hashCode(this.rowIndices);
        return result;
    }

    public String toString() {
        return "MutableMatrix(nrow=" + this.nrow + ", ncol=" + this.ncol + ", data=" + Arrays.toString(this.data) + ", rowIndices=" + Arrays.toString(this.rowIndices) + ")";
    }
}

