/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.linear.doubles;

import com.github.signaflo.math.linear.doubles.Matrix2;
import com.github.signaflo.math.linear.doubles.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

final class RowMatrix
implements Matrix2 {
    private final List<Vector> rowVectors;
    private final int nrow;
    private final int ncol;

    RowMatrix(@NonNull List<Vector> vectors) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        this.rowVectors = new ArrayList<Vector>(vectors);
        this.nrow = this.rowVectors.size();
        this.ncol = this.nrow > 0 ? this.rowVectors.get(0).size() : 0;
    }

    RowMatrix(int nrow, int ncol) {
        this.rowVectors = new ArrayList<Vector>(nrow);
        this.nrow = nrow;
        this.ncol = ncol;
    }

    RowMatrix(int nrow, int ncol, @NonNull List<Vector> vectors) {
        if (vectors == null) {
            throw new NullPointerException("vectors");
        }
        if (nrow != vectors.size()) {
            throw new IllegalArgumentException("The number of rows must equal the number of vectors.");
        }
        this.nrow = nrow;
        this.ncol = ncol;
        this.rowVectors = new ArrayList<Vector>(vectors);
    }

    @Override
    public List<Vector> getRows() {
        return new ArrayList<Vector>(this.rowVectors);
    }

    @Override
    public List<Vector> getColumns() {
        ArrayList<Vector> columns = new ArrayList<Vector>(this.ncol);
        if (this.rowVectors.isEmpty()) {
            return columns;
        }
        double[] columnElements = new double[this.nrow];
        for (int j = 0; j < this.ncol; ++j) {
            for (int i = 0; i < this.nrow; ++i) {
                columnElements[i] = this.rowVectors.get(i).at(j);
            }
            columns.add(Vector.from(columnElements));
        }
        return columns;
    }

    @Override
    public int nrow() {
        return this.nrow;
    }

    @Override
    public int ncol() {
        return this.ncol;
    }

    @Override
    public Matrix2 times(Matrix2 other) {
        if (this.ncol != other.nrow()) {
            throw new IllegalArgumentException("The number of columns of this matrix must equal the number of rows of the other matrix.");
        }
        if (this.nrow == 0 || other.ncol() == 0) {
            return new RowMatrix(this.nrow, other.ncol());
        }
        if (this.ncol == 0) {
            return this.filledMatrixFromEmptyMatrices(this.nrow, other.ncol());
        }
        List<Vector> otherColumns = other.getColumns();
        ArrayList<Vector> newRows = new ArrayList<Vector>(this.nrow);
        for (int i = 0; i < this.nrow; ++i) {
            double[] newRowElements = new double[other.ncol()];
            for (int j = 0; j < otherColumns.size(); ++j) {
                newRowElements[j] = this.rowVectors.get(i).dotProduct(otherColumns.get(j));
            }
            newRows.add(Vector.from(newRowElements));
        }
        return new RowMatrix(this.nrow, other.ncol(), newRows);
    }

    private Matrix2 filledMatrixFromEmptyMatrices(int nrow, int ncol) {
        ArrayList<Vector> rows = new ArrayList<Vector>(nrow);
        for (int i = 0; i < nrow; ++i) {
            rows.add(Vector.zeros(ncol));
        }
        return new RowMatrix(rows);
    }

    @Override
    public Vector times(Vector vector) {
        if (vector.size() != this.ncol) {
            throw new IllegalArgumentException("The number of elements of the given vector must equal the number of columns of this matrix.");
        }
        double[] newVectorElements = new double[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            newVectorElements[i] = this.rowVectors.get(i).dotProduct(vector);
        }
        return Vector.from(newVectorElements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Arrays.equals(o.getClass().getInterfaces(), this.getClass().getInterfaces())) {
            return false;
        }
        Matrix2 matrix2 = (Matrix2)o;
        if (this.nrow != matrix2.nrow()) {
            return false;
        }
        if (this.ncol != matrix2.ncol()) {
            return false;
        }
        return this.rowVectors.equals(matrix2.getRows());
    }

    public int hashCode() {
        int result = this.getColumns().hashCode();
        result = 31 * result + this.nrow;
        result = 31 * result + this.ncol;
        return result;
    }

    public String toString() {
        return "RowMatrix(rowVectors=" + this.rowVectors + ", nrow=" + this.nrow + ", ncol=" + this.ncol + ")";
    }
}

