/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.operations;

import com.github.signaflo.math.stats.Statistics;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class DoubleFunctions {
    private static final double EPSILON = Math.ulp(1.0);

    private DoubleFunctions() {
    }

    public static double[] arrayFrom(double ... data) {
        return (double[])data.clone();
    }

    public static double[] combine(double[] ... arrays) {
        int newArrayLength = 0;
        for (double[] array : arrays) {
            newArrayLength += array.length;
        }
        double[] newArray = new double[newArrayLength];
        newArrayLength = 0;
        for (double[] array : arrays) {
            System.arraycopy(array, 0, newArray, newArrayLength, array.length);
            newArrayLength += array.length;
        }
        return newArray;
    }

    public static double[][] combine(double[][] ... twoDArrays) {
        int newArrayLength = 0;
        for (double[][] twoDArray : twoDArrays) {
            newArrayLength += twoDArray.length;
        }
        double[][] newArray = new double[newArrayLength][];
        int i = 0;
        double[][][] dArray = twoDArrays;
        int n = dArray.length;
        for (int j = 0; j < n; ++j) {
            double[][] twoDArray;
            for (double[] array : twoDArray = dArray[j]) {
                newArray[i] = (double[])array.clone();
                ++i;
            }
        }
        return newArray;
    }

    public static double[] append(double[] original, double value) {
        double[] newArray = new double[original.length + 1];
        System.arraycopy(original, 0, newArray, 0, original.length);
        newArray[original.length] = value;
        return newArray;
    }

    public static double[] push(double value, double[] original) {
        double[] newArray = new double[original.length + 1];
        newArray[0] = value;
        System.arraycopy(original, 0, newArray, 1, original.length);
        return newArray;
    }

    public static double[][] push(double[] values, double[][] original) {
        double[][] newArrays = new double[original.length + 1][];
        newArrays[0] = (double[])values.clone();
        for (int i = 0; i < original.length; ++i) {
            newArrays[i + 1] = (double[])original[i].clone();
        }
        return newArrays;
    }

    public static double[] arrayFrom(Collection<? extends Number> data) {
        int size = data.size();
        double[] doubles = new double[size];
        Iterator<? extends Number> iterator = data.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            doubles[i] = iterator.next().doubleValue();
            ++i;
        }
        return doubles;
    }

    public static double[] arrayFrom(Number[] data) {
        int size = data.length;
        double[] doubles = new double[size];
        for (int i = 0; i < size; ++i) {
            doubles[i] = data[i].doubleValue();
        }
        return doubles;
    }

    static double[] arrayFrom(double[] data, int ... indices) {
        double[] newArray = new double[indices.length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = data[indices[i]];
        }
        return newArray;
    }

    public static double[] fill(int size, double value) {
        double[] filled = new double[size];
        for (int i = 0; i < filled.length; ++i) {
            filled[i] = value;
        }
        return filled;
    }

    public static List<Double> listFrom(double ... data) {
        return Doubles.asList((double[])((double[])data.clone()));
    }

    public static List<List<Double>> twoDListFrom(double[] ... data) {
        ArrayList<List<Double>> newList = new ArrayList<List<Double>>(data.length);
        for (double[] array : data) {
            newList.add(Doubles.asList((double[])((double[])array.clone())));
        }
        return newList;
    }

    public static double[][] twoDArrayFrom(List<List<Double>> data) {
        double[][] newArray = new double[data.size()][];
        for (int i = 0; i < data.size(); ++i) {
            newArray[i] = DoubleFunctions.arrayFrom((Collection<? extends Number>)data.get(i));
        }
        return newArray;
    }

    public static double[] slice(double[] data, int from, int to) {
        double[] sliced = new double[to - from];
        System.arraycopy(data, from, sliced, 0, to - from);
        return sliced;
    }

    public static double[] boxCox(double[] data, double lambda) {
        double[] boxCoxed = new double[data.length];
        if (Math.abs(lambda) < EPSILON) {
            for (int i = 0; i < boxCoxed.length; ++i) {
                boxCoxed[i] = Math.log(data[i]);
            }
        } else {
            for (int i = 0; i < boxCoxed.length; ++i) {
                boxCoxed[i] = (Math.pow(data[i], lambda) - 1.0) / lambda;
            }
        }
        return boxCoxed;
    }

    public static double[] inverseBoxCox(double[] data, double lambda) {
        double[] invBoxCoxed = new double[data.length];
        if (Math.abs(lambda) < EPSILON) {
            for (int i = 0; i < invBoxCoxed.length; ++i) {
                invBoxCoxed[i] = Math.exp(data[i]);
            }
        } else {
            for (int i = 0; i < invBoxCoxed.length; ++i) {
                invBoxCoxed[i] = Math.pow(data[i] * lambda + 1.0, 1.0 / lambda);
            }
        }
        return invBoxCoxed;
    }

    public static double[] sqrt(double ... data) {
        double[] sqrtData = new double[data.length];
        for (int i = 0; i < sqrtData.length; ++i) {
            sqrtData[i] = Math.sqrt(data[i]);
        }
        return sqrtData;
    }

    public static double round(double value, int precision) {
        double scale = Math.pow(10.0, precision);
        return (double)Math.round(value * scale) / scale;
    }

    public static double[] round(double[] values, int precision) {
        double[] rounded = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            rounded[i] = DoubleFunctions.round(values[i], precision);
        }
        return rounded;
    }

    static double[] demean(double[] data) {
        double mean = Statistics.meanOf(data);
        double[] demeaned = new double[data.length];
        for (int t = 0; t < data.length; ++t) {
            demeaned[t] = data[t] - mean;
        }
        return demeaned;
    }

    static double[] negativeOf(double[] data) {
        double[] negative = new double[data.length];
        for (int i = 0; i < negative.length; ++i) {
            negative[i] = -data[i];
        }
        return negative;
    }

    public static double[][] copy(double[][] values) {
        double[][] copied = new double[values.length][];
        for (int i = 0; i < values.length; ++i) {
            copied[i] = (double[])values[i].clone();
        }
        return copied;
    }
}

