/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.optim;

final class CubicInterpolation {
    private final double x1;
    private final double x2;
    private final double dydx1;
    private final double dydx2;
    private final double z;
    private final double w;

    public CubicInterpolation(double x1, double x2, double y1, double y2, double dydx1, double dydx2) {
        double y21;
        double y11;
        CubicInterpolation.validate(x1, x2);
        if (x1 > x2) {
            this.x1 = x2;
            y11 = y2;
            this.dydx1 = dydx2;
            this.x2 = x1;
            y21 = y1;
            this.dydx2 = dydx1;
        } else {
            this.x1 = x1;
            this.x2 = x2;
            y11 = y1;
            y21 = y2;
            this.dydx1 = dydx1;
            this.dydx2 = dydx2;
        }
        double s = 3.0 * ((y21 - y11) / (this.x2 - this.x1));
        this.z = s - this.dydx1 - this.dydx2;
        this.w = Math.sqrt(this.z * this.z - this.dydx1 * this.dydx2);
    }

    private static void validate(double x1, double x2) {
        if (x1 == x2) {
            throw new RuntimeException("The two x values cannot be the same. x1 and x2 were both equal to: " + x1);
        }
    }

    static double minimum(double x1, double x2, double y1, double y2, double dydx1, double dydx2) {
        CubicInterpolation.validate(x1, x2);
        double d1 = dydx2 + dydx1 - 3.0 * ((y2 - y1) / (x2 - x1));
        double d2 = Math.signum(x1 - x2) * Math.sqrt(d1 * d1 - dydx2 * dydx1);
        return x1 - (x1 - x2) * ((dydx1 + d2 - d1) / (dydx1 - dydx2 + 2.0 * d2));
    }

    final double minimum() {
        return this.x1 + (this.x2 - this.x1) * ((this.w - this.dydx1 - this.z) / (this.dydx2 - this.dydx1 + 2.0 * this.w));
    }
}

