/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.math.optim;

import com.github.signaflo.math.function.QuadraticFunction;
import com.github.signaflo.math.polynomial.interpolation.NewtonPolynomial;

final class QuadraticInterpolation {
    private final double x1;
    private final double x2;
    private final double y1;
    private final double y2;
    private final double dydx;
    private final double a;
    private final double b;

    QuadraticInterpolation(double x1, double x2, double y1, double y2, double dydx) {
        if (x1 == x2) {
            throw new IllegalArgumentException("The two x values cannot be the same. x1 and x2 were both equal to: " + x1);
        }
        if (x1 > x2) {
            this.x1 = x2;
            this.y1 = y2;
            this.x2 = x1;
            this.y2 = y1;
        } else {
            this.x1 = x1;
            this.x2 = x2;
            this.y1 = y1;
            this.y2 = y2;
        }
        this.dydx = dydx;
        this.a = this.computeA();
        this.b = this.computeB();
    }

    static double minimum(double x1, double x2, double y1, double y2, double dydx) {
        double z2;
        double w2;
        double z1;
        double w1;
        if (x1 == x2) {
            throw new IllegalArgumentException("The two x values cannot be the same. x1 and x2 were both equal to: " + x1);
        }
        if (x1 > x2) {
            w1 = x2;
            z1 = y2;
            w2 = x1;
            z2 = y1;
        } else {
            w1 = x1;
            w2 = x2;
            z1 = y1;
            z2 = y2;
        }
        double a = -(z1 - z2 - dydx * (w1 - w2)) / Math.pow(w1 - w2, 2.0);
        double b = dydx - 2.0 * w1 * a;
        return -b / (2.0 * a);
    }

    static double secantFormulaMinimum(double x1, double x2, double dydx1, double dydx2) {
        if (x1 <= x2) {
            return x1 - dydx1 * ((x1 - x2) / (dydx1 - dydx2));
        }
        return x2 - dydx2 * ((x2 - x1) / (dydx2 - dydx1));
    }

    static double threePointMinimum(double x1, double x2, double x3, double y1, double y2, double y3) {
        double[] point = new double[3];
        double[] value = new double[3];
        point[0] = x1;
        point[1] = x2;
        point[2] = x3;
        value[0] = y1;
        value[1] = y2;
        value[2] = y3;
        NewtonPolynomial np = new NewtonPolynomial(point, value);
        QuadraticFunction f = np.toQuadratic();
        if (f.hasMinimum()) {
            return f.extremePointDbl();
        }
        throw new IllegalStateException("The interpolating quadratic, " + f + ", had no minimum value.");
    }

    double computeA() {
        return -(this.y1 - this.y2 - this.dydx * (this.x1 - this.x2)) / Math.pow(this.x1 - this.x2, 2.0);
    }

    double computeB() {
        return this.dydx - 2.0 * this.x1 * this.a;
    }

    double minimum() {
        return -this.b / (2.0 * this.a);
    }
}

