/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.data;

import lombok.NonNull;

public final class Pair<T extends Comparable<T>, S extends Comparable<S>>
implements Comparable<Pair<T, S>> {
    private final T first;
    private final S second;

    static Pair<Integer, Integer> intPair(Integer first, Integer second) {
        return new Pair<Integer, Integer>(first, second);
    }

    public static <T extends Comparable<T>, S extends Comparable<S>> Pair<T, S> newPair(T first, S second) {
        return new Pair<T, S>(first, second);
    }

    private Pair(@NonNull T first, @NonNull S second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        this.first = first;
        this.second = second;
    }

    public T first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    @Override
    public int compareTo(@NonNull Pair<T, S> otherPair) {
        if (otherPair == null) {
            throw new NullPointerException("otherPair");
        }
        int result = this.first.compareTo(otherPair.first);
        if (result != 0) {
            return result;
        }
        return this.second.compareTo(otherPair.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        return this.first.equals(pair.first) && this.second.equals(pair.second);
    }

    public int hashCode() {
        int result = this.first.hashCode();
        result = 31 * result + this.second.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.first.toString() + ", " + this.second.toString() + ")";
    }
}

