/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.data;

import com.github.signaflo.math.stats.Statistics;
import com.google.common.primitives.Doubles;
import java.util.Arrays;
import java.util.List;

public final class Range {
    private static final double TOLERANCE = Math.sqrt(Math.ulp(1.0));
    private final double[] range;
    private final double by;

    Range(double from, double to, double by) {
        if (by <= 0.0) {
            throw new IllegalArgumentException("The by argument must be positive.");
        }
        this.by = by;
        int size = (int)(Math.abs((to - from) / by) + TOLERANCE) + 1;
        this.range = new double[size];
        if (size > 0) {
            this.range[0] = from;
        }
        for (int i = 1; i < this.range.length; ++i) {
            this.range[i] = this.range[i - 1] + Math.signum(to - from) * by;
        }
    }

    public static Range exclusiveRange(double from, double to, double by) {
        double dist = to - from;
        double ratio = dist / by;
        double offset = Math.abs(ratio - (double)((int)ratio)) < TOLERANCE ? Math.signum(dist) * by : 0.0;
        return new Range(from, to - offset, by);
    }

    public static Range inclusiveRange(double from, double to, double by) {
        return new Range(from, to, by);
    }

    public static Range exclusiveRange(double from, double to) {
        return Range.exclusiveRange(from, to, 1.0);
    }

    public static Range inclusiveRange(double from, double to) {
        return Range.inclusiveRange(from, to, 1.0);
    }

    public double[] asArray() {
        return (double[])this.range.clone();
    }

    public List<Double> asList() {
        return Doubles.asList((double[])((double[])this.range.clone()));
    }

    public double sum() {
        return Statistics.sumOf((double[])this.range);
    }

    public int size() {
        return this.range.length;
    }

    public double start() {
        return this.range[0];
    }

    public double end() {
        return this.range[this.range.length - 1];
    }

    public double at(int i) {
        return this.range[i];
    }

    public String toString() {
        return String.format("Range: %s to %s by %s", Double.toString(this.range[0]), Double.toString(this.range[this.range.length - 1]), Double.toString(this.by));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range other = (Range)o;
        if (!Arrays.equals(this.range, other.range)) {
            return false;
        }
        return Double.compare(this.by, other.by) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.range);
        long $by = Double.doubleToLongBits(this.by);
        result = result * 59 + (int)($by >>> 32 ^ $by);
        return result;
    }
}

