/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.data.regression;

import com.github.signaflo.data.regression.MultipleLinearRegression;
import com.github.signaflo.data.regression.MultipleRegressionBuilder;
import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.math.stats.Statistics;
import java.util.Arrays;
import org.ejml.alg.dense.mult.MatrixVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.QRDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

final class MultipleLinearRegressionModel
implements MultipleLinearRegression {
    private final double[][] predictors;
    private final double[][] XtXInv;
    private final double[] response;
    private final double[] beta;
    private final double[] standardErrors;
    private final double[] residuals;
    private final double[] fitted;
    private final boolean hasIntercept;
    private final double sigma2;

    private MultipleLinearRegressionModel(MultipleLinearRegressionBuilder builder) {
        this.predictors = builder.predictors;
        this.response = builder.response;
        this.hasIntercept = builder.hasIntercept;
        MatrixFormulation matrixFormulation = new MatrixFormulation();
        this.XtXInv = this.getXtXInverse(matrixFormulation);
        this.beta = matrixFormulation.getBetaEstimates();
        this.standardErrors = matrixFormulation.getBetaStandardErrors(this.beta.length);
        this.fitted = matrixFormulation.computeFittedValues();
        this.residuals = matrixFormulation.getResiduals();
        this.sigma2 = matrixFormulation.getSigma2();
    }

    private double[][] getXtXInverse(MatrixFormulation matrixFormulation) {
        DenseMatrix64F XtXInvMatrix = matrixFormulation.XtXInv.copy();
        int dim = XtXInvMatrix.getNumCols();
        double[][] XtXInvArray = new double[dim][dim];
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                XtXInvArray[i][j] = XtXInvMatrix.get(i, j);
            }
        }
        return XtXInvArray;
    }

    @Override
    public double[][] predictors() {
        double[][] copy = new double[this.predictors.length][];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = (double[])this.predictors[i].clone();
        }
        return copy;
    }

    @Override
    public double[][] designMatrix() {
        if (this.hasIntercept) {
            double[][] copy = new double[this.predictors.length + 1][];
            copy[0] = DoubleFunctions.fill((int)this.response.length, (double)1.0);
            for (int i = 1; i < copy.length; ++i) {
                copy[i] = (double[])this.predictors[i - 1].clone();
            }
            return copy;
        }
        return this.predictors();
    }

    @Override
    public double[][] XtXInverse() {
        double[][] copy = new double[this.XtXInv.length][];
        for (int i = 0; i < copy.length; ++i) {
            copy[i] = (double[])this.XtXInv[i].clone();
        }
        return copy;
    }

    @Override
    public double[] beta() {
        return (double[])this.beta.clone();
    }

    @Override
    public double[] standardErrors() {
        return (double[])this.standardErrors.clone();
    }

    @Override
    public double sigma2() {
        return this.sigma2;
    }

    @Override
    public double[] response() {
        return (double[])this.response.clone();
    }

    @Override
    public double[] fitted() {
        return (double[])this.fitted.clone();
    }

    @Override
    public double[] residuals() {
        return (double[])this.residuals.clone();
    }

    @Override
    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    MultipleLinearRegressionModel withHasIntercept(boolean hasIntercept) {
        return new MultipleLinearRegressionBuilder().from(this).hasIntercept(hasIntercept).build();
    }

    MultipleLinearRegressionModel withResponse(double[] response) {
        return new MultipleLinearRegressionBuilder().from(this).response(response).build();
    }

    MultipleLinearRegressionModel withPredictors(double[] ... predictors) {
        return new MultipleLinearRegressionBuilder().from(this).predictors(predictors).build();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleLinearRegressionModel)) {
            return false;
        }
        MultipleLinearRegressionModel other = (MultipleLinearRegressionModel)o;
        if (!Arrays.deepEquals((Object[])this.predictors, (Object[])other.predictors)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.XtXInv, (Object[])other.XtXInv)) {
            return false;
        }
        if (!Arrays.equals(this.response, other.response)) {
            return false;
        }
        if (!Arrays.equals(this.beta, other.beta)) {
            return false;
        }
        if (!Arrays.equals(this.standardErrors, other.standardErrors)) {
            return false;
        }
        if (!Arrays.equals(this.residuals, other.residuals)) {
            return false;
        }
        if (!Arrays.equals(this.fitted, other.fitted)) {
            return false;
        }
        if (this.hasIntercept != other.hasIntercept) {
            return false;
        }
        return Double.compare(this.sigma2, other.sigma2) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode((Object[])this.predictors);
        result = result * 59 + Arrays.deepHashCode((Object[])this.XtXInv);
        result = result * 59 + Arrays.hashCode(this.response);
        result = result * 59 + Arrays.hashCode(this.beta);
        result = result * 59 + Arrays.hashCode(this.standardErrors);
        result = result * 59 + Arrays.hashCode(this.residuals);
        result = result * 59 + Arrays.hashCode(this.fitted);
        result = result * 59 + (this.hasIntercept ? 79 : 97);
        long $sigma2 = Double.doubleToLongBits(this.sigma2);
        result = result * 59 + (int)($sigma2 >>> 32 ^ $sigma2);
        return result;
    }

    public String toString() {
        return "MultipleLinearRegressionModel(predictors=" + Arrays.deepToString((Object[])this.predictors) + ", XtXInv=" + Arrays.deepToString((Object[])this.XtXInv) + ", response=" + Arrays.toString(this.response) + ", beta=" + Arrays.toString(this.beta) + ", standardErrors=" + Arrays.toString(this.standardErrors) + ", residuals=" + Arrays.toString(this.residuals) + ", fitted=" + Arrays.toString(this.fitted) + ", hasIntercept=" + this.hasIntercept + ", sigma2=" + this.sigma2 + ")";
    }

    private class MatrixFormulation {
        private final DenseMatrix64F X;
        private final DenseMatrix64F Xt;
        private final DenseMatrix64F XtXInv;
        private final DenseMatrix64F b;
        private final DenseMatrix64F y;
        private final double[] fitted;
        private final double[] residuals;
        private final double sigma2;
        private final DenseMatrix64F covarianceMatrix;

        private MatrixFormulation() {
            int numRows = MultipleLinearRegressionModel.this.response.length;
            int numCols = MultipleLinearRegressionModel.this.predictors.length + (MultipleLinearRegressionModel.this.hasIntercept ? 1 : 0);
            this.X = this.createMatrixA(numRows, numCols);
            this.Xt = new DenseMatrix64F(numCols, numRows);
            CommonOps.transpose((DenseMatrix64F)this.X, (DenseMatrix64F)this.Xt);
            this.XtXInv = new DenseMatrix64F(numCols, numCols);
            this.b = new DenseMatrix64F(numCols, 1);
            this.y = new DenseMatrix64F(numRows, 1);
            this.solveSystem(numRows, numCols);
            this.fitted = this.computeFittedValues();
            this.residuals = this.computeResiduals();
            this.sigma2 = this.estimateSigma2(numCols);
            this.covarianceMatrix = new DenseMatrix64F(numCols, numCols);
            CommonOps.scale((double)this.sigma2, (D1Matrix64F)this.XtXInv, (D1Matrix64F)this.covarianceMatrix);
        }

        private void solveSystem(int numRows, int numCols) {
            LinearSolver qrSolver = LinearSolverFactory.qr((int)numRows, (int)numCols);
            QRDecomposition decomposition = (QRDecomposition)qrSolver.getDecomposition();
            qrSolver.setA((Matrix)this.X);
            this.y.setData(MultipleLinearRegressionModel.this.response);
            qrSolver.solve((Matrix)this.y, (Matrix)this.b);
            DenseMatrix64F R = (DenseMatrix64F)decomposition.getR(null, true);
            LinearSolver linearSolver = LinearSolverFactory.linear((int)numCols);
            linearSolver.setA((Matrix)R);
            DenseMatrix64F Rinverse = new DenseMatrix64F(numCols, numCols);
            linearSolver.invert((Matrix)Rinverse);
            CommonOps.multOuter((RowD1Matrix64F)Rinverse, (RowD1Matrix64F)this.XtXInv);
        }

        private DenseMatrix64F createMatrixA(int numRows, int numCols) {
            double[] data = MultipleLinearRegressionModel.this.hasIntercept ? DoubleFunctions.fill((int)numRows, (double)1.0) : DoubleFunctions.arrayFrom((double[])new double[0]);
            for (double[] predictor : MultipleLinearRegressionModel.this.predictors) {
                data = DoubleFunctions.combine((double[][])new double[][]{data, DoubleFunctions.arrayFrom((double[])predictor)});
            }
            boolean isRowMajor = false;
            return new DenseMatrix64F(numRows, numCols, isRowMajor, data);
        }

        private double[] computeFittedValues() {
            DenseMatrix64F fitted = new DenseMatrix64F(MultipleLinearRegressionModel.this.response.length, 1);
            MatrixVectorMult.mult((RowD1Matrix64F)this.X, (D1Matrix64F)this.b, (D1Matrix64F)fitted);
            return fitted.getData();
        }

        private double[] computeResiduals() {
            double[] residuals = new double[this.fitted.length];
            for (int i = 0; i < residuals.length; ++i) {
                residuals[i] = MultipleLinearRegressionModel.this.response[i] - this.fitted[i];
            }
            return residuals;
        }

        private double[] getResiduals() {
            return (double[])this.residuals.clone();
        }

        private double estimateSigma2(int df) {
            double ssq = Statistics.sumOfSquared((double[])DoubleFunctions.arrayFrom((double[])this.residuals));
            return ssq / (double)(this.residuals.length - df);
        }

        private double[] getBetaStandardErrors(int numCols) {
            DenseMatrix64F diag = new DenseMatrix64F(numCols, 1);
            CommonOps.extractDiag((DenseMatrix64F)this.covarianceMatrix, (DenseMatrix64F)diag);
            return DoubleFunctions.sqrt((double[])diag.getData());
        }

        private double[] getBetaEstimates() {
            return (double[])this.b.getData().clone();
        }

        private double getSigma2() {
            return this.sigma2;
        }
    }

    static final class MultipleLinearRegressionBuilder
    implements MultipleRegressionBuilder {
        private double[][] predictors;
        private double[] response;
        private boolean hasIntercept = true;

        MultipleLinearRegressionBuilder() {
        }

        @Override
        public final MultipleLinearRegressionBuilder from(MultipleLinearRegression regression) {
            this.predictors = DoubleFunctions.copy((double[][])regression.predictors());
            this.response = (double[])regression.response().clone();
            this.hasIntercept = regression.hasIntercept();
            return this;
        }

        @Override
        public MultipleLinearRegressionBuilder predictors(double[] ... predictors) {
            this.predictors = new double[predictors.length][];
            for (int i = 0; i < predictors.length; ++i) {
                this.predictors[i] = (double[])predictors[i].clone();
            }
            return this;
        }

        @Override
        public MultipleLinearRegressionBuilder response(double[] response) {
            this.response = (double[])response.clone();
            return this;
        }

        @Override
        public MultipleLinearRegressionBuilder hasIntercept(boolean hasIntercept) {
            this.hasIntercept = hasIntercept;
            return this;
        }

        @Override
        public MultipleLinearRegressionModel build() {
            return new MultipleLinearRegressionModel(this);
        }
    }
}

