/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.data.regression;

import com.github.signaflo.data.DoublePair;
import com.github.signaflo.data.regression.LinearRegressionPrediction;

class MultipleLinearRegressionPrediction
implements LinearRegressionPrediction {
    private final double estimate;
    private final double fitStandardError;
    private final DoublePair confidenceInterval;
    private final DoublePair predictionInterval;

    MultipleLinearRegressionPrediction(double estimate, double fitStandardError, DoublePair confidenceInterval, DoublePair predictionInterval) {
        this.estimate = estimate;
        this.fitStandardError = fitStandardError;
        this.confidenceInterval = confidenceInterval;
        this.predictionInterval = predictionInterval;
    }

    @Override
    public double fitStandardError() {
        return this.fitStandardError;
    }

    @Override
    public DoublePair confidenceInterval() {
        return this.confidenceInterval;
    }

    @Override
    public DoublePair predictionInterval() {
        return this.predictionInterval;
    }

    @Override
    public double estimate() {
        return this.estimate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleLinearRegressionPrediction)) {
            return false;
        }
        MultipleLinearRegressionPrediction other = (MultipleLinearRegressionPrediction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.estimate, other.estimate) != 0) {
            return false;
        }
        if (Double.compare(this.fitStandardError, other.fitStandardError) != 0) {
            return false;
        }
        DoublePair this$confidenceInterval = this.confidenceInterval;
        DoublePair other$confidenceInterval = other.confidenceInterval;
        if (this$confidenceInterval == null ? other$confidenceInterval != null : !((Object)this$confidenceInterval).equals(other$confidenceInterval)) {
            return false;
        }
        DoublePair this$predictionInterval = this.predictionInterval;
        DoublePair other$predictionInterval = other.predictionInterval;
        return !(this$predictionInterval == null ? other$predictionInterval != null : !((Object)this$predictionInterval).equals(other$predictionInterval));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultipleLinearRegressionPrediction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $estimate = Double.doubleToLongBits(this.estimate);
        result = result * 59 + (int)($estimate >>> 32 ^ $estimate);
        long $fitStandardError = Double.doubleToLongBits(this.fitStandardError);
        result = result * 59 + (int)($fitStandardError >>> 32 ^ $fitStandardError);
        DoublePair $confidenceInterval = this.confidenceInterval;
        result = result * 59 + ($confidenceInterval == null ? 43 : ((Object)$confidenceInterval).hashCode());
        DoublePair $predictionInterval = this.predictionInterval;
        result = result * 59 + ($predictionInterval == null ? 43 : ((Object)$predictionInterval).hashCode());
        return result;
    }

    public String toString() {
        return "MultipleLinearRegressionPrediction(estimate=" + this.estimate + ", fitStandardError=" + this.fitStandardError + ", confidenceInterval=" + this.confidenceInterval + ", predictionInterval=" + this.predictionInterval + ")";
    }
}

