/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.data.visualization;

import com.github.signaflo.data.DataSet;
import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.timeseries.TimeSeries;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Component;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import org.knowm.xchart.XChartPanel;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.lines.SeriesLines;
import org.knowm.xchart.style.markers.Circle;
import org.knowm.xchart.style.markers.Marker;
import org.knowm.xchart.style.markers.SeriesMarkers;

public class Plots {
    private Plots() {
    }

    public static void plot(TimeSeries timeSeries) {
        Plots.plot(timeSeries, "Time Series Plot");
    }

    public static void plot(TimeSeries timeSeries, String title) {
        Plots.plot(timeSeries, title, "values");
    }

    public static void plot(TimeSeries timeSeries, String title, String seriesName) {
        Thread plotThread = new Thread(() -> {
            ArrayList<Date> xAxis = new ArrayList<Date>(timeSeries.observationTimes().size());
            for (OffsetDateTime dateTime : timeSeries.observationTimes()) {
                xAxis.add(Date.from(dateTime.toInstant()));
            }
            List seriesList = Doubles.asList((double[])DoubleFunctions.round((double[])timeSeries.asArray(), (int)2));
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(600)).width(800)).title(title)).build();
            XYSeries residualSeries = chart.addSeries(seriesName, xAxis, seriesList);
            residualSeries.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
            residualSeries.setMarker((Marker)new Circle()).setMarkerColor(Color.RED);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame(title);
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        });
        plotThread.start();
    }

    public static void plotAcf(TimeSeries timeSeries, int k) {
        int i;
        double[] acf = timeSeries.autoCorrelationUpToLag(k);
        double[] lags = new double[k + 1];
        for (int i2 = 1; i2 < lags.length; ++i2) {
            lags[i2] = i2;
        }
        double upper = (double)(-1 / timeSeries.size()) + 2.0 / Math.sqrt(timeSeries.size());
        double lower = (double)(-1 / timeSeries.size()) - 2.0 / Math.sqrt(timeSeries.size());
        double[] upperLine = new double[lags.length];
        double[] lowerLine = new double[lags.length];
        for (i = 0; i < lags.length; ++i) {
            upperLine[i] = upper;
        }
        for (i = 0; i < lags.length; ++i) {
            lowerLine[i] = lower;
        }
        Thread plotThread = new Thread(() -> {
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(800)).width(1200)).title("Autocorrelations By Lag")).build();
            XYSeries series = chart.addSeries("Autocorrelation", lags, acf);
            XYSeries series2 = chart.addSeries("Upper Bound", lags, upperLine);
            XYSeries series3 = chart.addSeries("Lower Bound", lags, lowerLine);
            ((XYStyler)chart.getStyler()).setChartFontColor(Color.BLACK).setSeriesColors(new Color[]{Color.BLACK, Color.BLUE, Color.BLUE});
            series.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter);
            series2.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line).setMarker(SeriesMarkers.NONE).setLineStyle(SeriesLines.DASH_DASH);
            series3.setXYSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Line).setMarker(SeriesMarkers.NONE).setLineStyle(SeriesLines.DASH_DASH);
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Autocorrelation by Lag");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        });
        plotThread.start();
    }

    public static void plot(DataSet dataSet) {
        Thread plotThread = new Thread(() -> {
            double[] indices = new double[dataSet.size()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).title("Scatter Plot")).xAxisTitle("Index").yAxisTitle("Values").build();
            ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter).setChartFontColor(Color.BLACK).setSeriesColors(new Color[]{Color.BLUE});
            chart.addSeries("com/github/signaflo/data", indices, dataSet.asArray());
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Data Set");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        });
        plotThread.start();
    }

    public static void plot(DataSet firstDataSet, DataSet secondDataSet) {
        Thread plotThread = new Thread(() -> {
            XYChart chart = ((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().theme(Styler.ChartTheme.GGPlot2)).height(600)).width(800)).title("Scatter Plot")).xAxisTitle("X").yAxisTitle("Y").build();
            ((XYStyler)chart.getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Scatter).setChartFontColor(Color.DARK_GRAY).setSeriesColors(new Color[]{Color.BLUE});
            chart.addSeries("Y against X", firstDataSet.asArray(), secondDataSet.asArray());
            XChartPanel panel = new XChartPanel((Chart)chart);
            JFrame frame = new JFrame("Scatter Plot");
            frame.setDefaultCloseOperation(2);
            frame.add((Component)panel);
            frame.pack();
            frame.setVisible(true);
        });
        plotThread.start();
    }
}

