/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries;

import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class Ts {
    private static final int ZONE_OFFSET = 0;

    private Ts() {
    }

    public static TimeSeries newAnnualSeries(int startYear, double ... series) {
        LocalDateTime localDateTime = LocalDateTime.of(startYear, Month.JANUARY, 1, 0, 0);
        OffsetDateTime startPeriod = OffsetDateTime.of(localDateTime, ZoneOffset.ofHours(0));
        return TimeSeries.from(TimePeriod.oneYear(), startPeriod, series);
    }

    public static TimeSeries newAnnualSeries(double ... series) {
        return TimeSeries.from(TimePeriod.oneYear(), series);
    }

    public static TimeSeries newMonthlySeries(double ... series) {
        return TimeSeries.from(TimePeriod.oneMonth(), series);
    }

    public static TimeSeries newMonthlySeries(int startYear, int startMonth, double ... series) {
        return Ts.newMonthlySeries(startYear, startMonth, 1, series);
    }

    public static TimeSeries newMonthlySeries(int startYear, int startMonth, int startDay, double ... series) {
        OffsetDateTime startPeriod = OffsetDateTime.of(startYear, startMonth, startDay, 0, 0, 0, 0, ZoneOffset.ofHours(0));
        return TimeSeries.from(TimePeriod.oneMonth(), startPeriod, series);
    }

    public static TimeSeries newQuarterlySeries(double ... series) {
        return TimeSeries.from(TimePeriod.oneQuarter(), series);
    }

    public static TimeSeries newQuarterlySeries(int startYear, int startQuarter, double ... series) {
        int startMonth = 3 * startQuarter - 2;
        OffsetDateTime startPeriod = OffsetDateTime.of(startYear, startMonth, 1, 0, 0, 0, 0, ZoneOffset.ofHours(0));
        return TimeSeries.from(TimePeriod.oneQuarter(), startPeriod, series);
    }

    public static TimeSeries newWeeklySeries(double ... series) {
        return TimeSeries.from(TimePeriod.oneWeek(), series);
    }

    public static TimeSeries newWeeklySeries(int startYear, int startMonth, int startDay, double ... series) {
        OffsetDateTime startPeriod = OffsetDateTime.of(startYear, startMonth, startDay, 0, 0, 0, 0, ZoneOffset.ofHours(0));
        return TimeSeries.from(TimePeriod.oneWeek(), startPeriod, series);
    }
}

