/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model;

import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.math.stats.distributions.StudentsT;
import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecaster;
import com.github.signaflo.timeseries.model.MeanForecast;
import java.time.OffsetDateTime;

class MeanForecaster
implements Forecaster {
    private final TimeSeries timeSeries;

    MeanForecaster(TimeSeries timeSeries) {
        this.timeSeries = timeSeries;
    }

    @Override
    public TimeSeries computeUpperPredictionBounds(TimeSeries forecast, int steps, double alpha) {
        if (steps < 1) {
            throw new IllegalArgumentException("The number of steps ahead to forecast must be greater than or equal to 1, but was " + steps);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The value of alpha must be between 0 and 1, but was " + alpha);
        }
        TimeSeries fcstStdError = this.getFcstErrors(forecast, steps, alpha);
        double[] upperPredictionValues = new double[steps];
        for (int t = 0; t < steps; ++t) {
            upperPredictionValues[t] = forecast.at(t) + fcstStdError.at(t);
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.observationTimes().get(0), upperPredictionValues);
    }

    @Override
    public TimeSeries computeLowerPredictionBounds(TimeSeries forecast, int steps, double alpha) {
        if (steps < 1) {
            throw new IllegalArgumentException("The number of steps ahead to forecast must be greater than or equal to 1, but was " + steps);
        }
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("The value of alpha must be between 0 and 1, but was " + alpha);
        }
        double[] lowerPredictionValues = new double[steps];
        TimeSeries fcstStdError = this.getFcstErrors(forecast, steps, alpha);
        for (int t = 0; t < steps; ++t) {
            lowerPredictionValues[t] = forecast.at(t) - fcstStdError.at(t);
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.observationTimes().get(0), lowerPredictionValues);
    }

    private TimeSeries getFcstErrors(TimeSeries forecast, int steps, double alpha) {
        double[] errors = new double[steps];
        double criticalValue = new StudentsT(this.timeSeries.size() - 1).quantile(1.0 - alpha / 2.0);
        double variance = this.timeSeries.variance();
        double meanStdError = variance / (double)this.timeSeries.size();
        double fcstStdError = Math.sqrt(variance + meanStdError);
        for (int t = 0; t < errors.length; ++t) {
            errors[t] = criticalValue * fcstStdError;
        }
        return TimeSeries.from(forecast.timePeriod(), forecast.observationTimes().get(0), errors);
    }

    @Override
    public TimeSeries computePointForecasts(int steps) {
        int n = this.timeSeries.size();
        TimePeriod timePeriod = this.timeSeries.timePeriod();
        double[] forecasted = DoubleFunctions.fill((int)steps, (double)this.timeSeries.mean());
        OffsetDateTime startTime = this.timeSeries.observationTimes().get(n - 1).plus(timePeriod.periodLength() * timePeriod.timeUnit().unitLength(), timePeriod.timeUnit().temporalUnit());
        return TimeSeries.from(timePeriod, startTime, forecasted);
    }

    @Override
    public MeanForecast forecast(int steps, double alpha) {
        TimeSeries forecast = this.computePointForecasts(steps);
        TimeSeries lowerBounds = this.computeLowerPredictionBounds(forecast, steps, alpha);
        TimeSeries upperBounds = this.computeUpperPredictionBounds(forecast, steps, alpha);
        return new MeanForecast(forecast, lowerBounds, upperBounds);
    }
}

