/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecast;
import com.github.signaflo.timeseries.model.Model;
import com.github.signaflo.timeseries.model.arima.ArimaCoefficients;
import com.github.signaflo.timeseries.model.arima.ArimaModel;
import com.github.signaflo.timeseries.model.arima.ArimaOrder;
import lombok.NonNull;

public interface Arima
extends Model {
    public static Arima model(@NonNull TimeSeries observations, @NonNull ArimaOrder order) {
        if (observations == null) {
            throw new NullPointerException("observations");
        }
        if (order == null) {
            throw new NullPointerException("order");
        }
        return new ArimaModel(observations, order, TimePeriod.oneYear(), FittingStrategy.CSSML);
    }

    public static Arima model(@NonNull TimeSeries observations, @NonNull ArimaOrder order, @NonNull TimePeriod seasonalCycle) {
        if (observations == null) {
            throw new NullPointerException("observations");
        }
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (seasonalCycle == null) {
            throw new NullPointerException("seasonalCycle");
        }
        return new ArimaModel(observations, order, seasonalCycle, FittingStrategy.CSSML);
    }

    public static Arima model(@NonNull TimeSeries observations, @NonNull ArimaOrder order, @NonNull FittingStrategy fittingStrategy) {
        if (observations == null) {
            throw new NullPointerException("observations");
        }
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (fittingStrategy == null) {
            throw new NullPointerException("fittingStrategy");
        }
        return new ArimaModel(observations, order, TimePeriod.oneYear(), fittingStrategy);
    }

    public static Arima model(@NonNull TimeSeries observations, @NonNull ArimaOrder order, @NonNull TimePeriod seasonalCycle, @NonNull FittingStrategy fittingStrategy) {
        if (observations == null) {
            throw new NullPointerException("observations");
        }
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (seasonalCycle == null) {
            throw new NullPointerException("seasonalCycle");
        }
        if (fittingStrategy == null) {
            throw new NullPointerException("fittingStrategy");
        }
        return new ArimaModel(observations, order, seasonalCycle, fittingStrategy);
    }

    public static Arima model(@NonNull TimeSeries observations, @NonNull ArimaCoefficients coeffs, @NonNull FittingStrategy fittingStrategy) {
        if (observations == null) {
            throw new NullPointerException("observations");
        }
        if (coeffs == null) {
            throw new NullPointerException("coeffs");
        }
        if (fittingStrategy == null) {
            throw new NullPointerException("fittingStrategy");
        }
        return new ArimaModel(observations, coeffs, TimePeriod.oneYear(), fittingStrategy);
    }

    public static Arima model(@NonNull TimeSeries observations, @NonNull ArimaCoefficients coeffs, @NonNull TimePeriod seasonalCycle) {
        if (observations == null) {
            throw new NullPointerException("observations");
        }
        if (coeffs == null) {
            throw new NullPointerException("coeffs");
        }
        if (seasonalCycle == null) {
            throw new NullPointerException("seasonalCycle");
        }
        return new ArimaModel(observations, coeffs, seasonalCycle, FittingStrategy.CSSML);
    }

    public static Arima model(@NonNull TimeSeries observations, @NonNull ArimaCoefficients coeffs, @NonNull TimePeriod seasonalCycle, @NonNull FittingStrategy fittingStrategy) {
        if (observations == null) {
            throw new NullPointerException("observations");
        }
        if (coeffs == null) {
            throw new NullPointerException("coeffs");
        }
        if (seasonalCycle == null) {
            throw new NullPointerException("seasonalCycle");
        }
        if (fittingStrategy == null) {
            throw new NullPointerException("fittingStrategy");
        }
        return new ArimaModel(observations, coeffs, seasonalCycle, fittingStrategy);
    }

    @Override
    public Forecast forecast(int var1, double var2);

    @Override
    public TimeSeries observations();

    @Override
    public TimeSeries fittedSeries();

    @Override
    public TimeSeries predictionErrors();

    public double sigma2();

    public int seasonalFrequency();

    public double[] stdErrors();

    public ArimaCoefficients coefficients();

    public ArimaOrder order();

    public double logLikelihood();

    public double aic();

    public static enum FittingStrategy {
        CSS("conditional sum-of-squares"),
        ML("maximum likelihood"),
        CSSML("conditional sum-of-squares, then maximum likelihood");

        private final String description;

        private FittingStrategy(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Drift {
        INCLUDE(1),
        EXCLUDE(0);

        private final int drift;

        private Drift(int drift) {
            this.drift = drift;
        }

        public int asInt() {
            return this.drift;
        }

        public boolean include() {
            return this == INCLUDE;
        }
    }

    public static enum Constant {
        INCLUDE(1),
        EXCLUDE(0);

        private final int constant;

        private Constant(int constant) {
            this.constant = constant;
        }

        public int asInt() {
            return this.constant;
        }

        public boolean include() {
            return this == INCLUDE;
        }
    }
}

