/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.math.operations.DoubleFunctions;

final class ArimaStateSpace {
    private final double[] observations;
    private final double[] arParams;
    private final double[] maParams;
    private final double[] delta;
    private final double[][] transitionMatrix;
    private final double[] disturbanceVector;
    private final double[] observationVector;
    private final int r;
    private final int d;

    ArimaStateSpace(double[] observations, double[] arParams, double[] maParams, double[] delta) {
        this.observations = (double[])observations.clone();
        this.arParams = (double[])arParams.clone();
        this.maParams = (double[])maParams.clone();
        this.delta = (double[])delta.clone();
        this.r = Math.max(arParams.length, maParams.length + 1);
        this.d = delta.length;
        this.transitionMatrix = this.createTransitionMatrix();
        this.disturbanceVector = this.createMovingAverageVector();
        this.observationVector = this.createStateEffectsVector();
    }

    private double[] createStateEffectsVector() {
        double[] Z = new double[this.r];
        Z[0] = 1.0;
        return DoubleFunctions.combine((double[][])new double[][]{Z, this.delta});
    }

    private double[] createMovingAverageVector() {
        double[] R = new double[this.r + this.d];
        R[0] = 1.0;
        System.arraycopy(this.maParams, 0, R, 1, this.maParams.length);
        return R;
    }

    private double[][] createTransitionMatrix() {
        int i;
        double[][] T = new double[this.r + this.d][this.r + this.d];
        for (i = 0; i < this.arParams.length; ++i) {
            T[i][0] = this.arParams[i];
        }
        for (i = 1; i < this.r; ++i) {
            T[i - 1][i] = 1.0;
        }
        for (i = 0; i < this.d; ++i) {
            T[this.r][this.r + i] = this.delta[i];
        }
        if (this.d > 0) {
            T[this.r][0] = 1.0;
        }
        for (i = 0; i < this.d - 1; ++i) {
            T[this.r + i + 1][this.r + i] = 1.0;
            T[this.r][this.r + i] = this.delta[i];
        }
        return T;
    }

    double[] observations() {
        return (double[])this.observations.clone();
    }

    double[] arParams() {
        return (double[])this.arParams.clone();
    }

    double[] maParams() {
        return (double[])this.maParams.clone();
    }

    final double[][] transitionMatrix() {
        return (double[][])this.transitionMatrix.clone();
    }

    final double[] movingAverageVector() {
        return (double[])this.disturbanceVector.clone();
    }

    final double[] stateEffectsVector() {
        return (double[])this.observationVector.clone();
    }

    final int r() {
        return this.r;
    }

    final int d() {
        return this.d;
    }
}

