/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.arima;

import com.github.signaflo.timeseries.model.arima.ArmaStateSpace;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.ops.CommonOps;

final class ArmaKalmanFilter {
    private final double[] y;
    private final int r;
    private final DenseMatrix64F transitionFunction;
    private final RowD1Matrix64F stateDisturbance;
    private final RowD1Matrix64F predictedState;
    private final RowD1Matrix64F filteredState;
    private final DenseMatrix64F predictedStateCovariance;
    private final RowD1Matrix64F filteredStateCovariance;
    private final double[] predictionErrorVariance;
    private final double[] predictionError;
    private final DenseMatrix64F predictedCovarianceFirstColumn;
    private final KalmanOutput kalmanOutput;

    ArmaKalmanFilter(ArmaStateSpace ss) {
        this.y = ss.differencedSeries();
        this.r = ss.r();
        this.transitionFunction = new DenseMatrix64F(ss.transitionMatrix());
        DenseMatrix64F R = new DenseMatrix64F(this.r, 1, true, ss.movingAverageVector());
        this.stateDisturbance = new DenseMatrix64F(this.r, this.r);
        CommonOps.multOuter((RowD1Matrix64F)R, (RowD1Matrix64F)this.stateDisturbance);
        this.predictedState = new DenseMatrix64F(this.r, 1, true, new double[this.r]);
        this.filteredState = new DenseMatrix64F(this.r, 1, true, new double[this.r]);
        this.predictedStateCovariance = this.initializePredictedCovariance(ss);
        this.filteredStateCovariance = new DenseMatrix64F(this.r, this.r);
        this.predictionErrorVariance = new double[this.y.length];
        this.predictionError = new double[this.y.length];
        this.predictedCovarianceFirstColumn = new DenseMatrix64F(this.r, 1);
        CommonOps.extractColumn((DenseMatrix64F)this.predictedStateCovariance, (int)0, (DenseMatrix64F)this.predictedCovarianceFirstColumn);
        this.kalmanOutput = this.filter();
    }

    static double[] getInitialStateCovariance(double[] phi, double[] theta) {
        int i;
        int i2;
        int p = phi.length;
        int q = theta.length;
        if (p == 0 && q == 0) {
            return new double[]{1.0};
        }
        int r = Math.max(p, q + 1);
        int np = r * (r + 1) / 2;
        double[] P = new double[np];
        double[] V = new double[np];
        double[] xrow = new double[np];
        int nrbar = np * (np - 1) / 2;
        int fault = ArmaKalmanFilter.validate(p, q, r, np, nrbar);
        if (fault != 0) {
            throw new RuntimeException("Validation Error # " + fault);
        }
        for (int i3 = 1; i3 < r; ++i3) {
            V[i3] = 0.0;
            if (i3 > q) continue;
            V[i3] = theta[i3 - 1];
        }
        V[0] = 1.0;
        int index = r;
        for (int j = 1; j < r; ++j) {
            double vj = V[j];
            for (i2 = j; i2 < r; ++i2) {
                V[index++] = V[i2] * vj;
            }
        }
        if (p == 0) {
            int indexn = np;
            index = np;
            for (i2 = 0; i2 < r; ++i2) {
                for (int j = 0; j <= i2; ++j) {
                    P[--index] = V[index];
                    if (j == 0) continue;
                    int n = index;
                    P[n] = P[n] + P[--indexn];
                }
            }
            return P;
        }
        double[] rbar = new double[nrbar];
        double[] thetab = new double[np];
        double[] xnext = new double[np];
        index = 0;
        int index1 = -1;
        int npr = np - r;
        int npr1 = npr + 1;
        int indexj = npr;
        int index2 = npr - 1;
        for (int j = 0; j < r; ++j) {
            double phij = j < p ? phi[j] : 0.0;
            xnext[indexj++] = 0.0;
            int indexi = npr1 + j;
            for (int i4 = j; i4 < r; ++i4) {
                double phii;
                double ynext = V[index++];
                double d = phii = i4 < p ? phi[i4] : 0.0;
                if (j != r - 1) {
                    xnext[indexj] = -phii;
                    if (i4 != r - 1) {
                        int n = indexi;
                        xnext[n] = xnext[n] - phij;
                        xnext[++index1] = -1.0;
                    }
                }
                xnext[npr] = -phii * phij;
                if (++index2 >= np) {
                    index2 = 0;
                }
                int n = index2;
                xnext[n] = xnext[n] + 1.0;
                ArmaKalmanFilter.inclu2(np, xnext, xrow, ynext, P, rbar, thetab);
                xnext[index2] = 0.0;
                if (i4 == r - 1) continue;
                xnext[indexi++] = 0.0;
                xnext[index1] = 0.0;
            }
        }
        ArmaKalmanFilter.regres(np, nrbar, rbar, thetab, P);
        index = npr;
        for (i = 0; i < r; ++i) {
            xnext[i] = P[index++];
        }
        index = np - 1;
        index1 = npr - 1;
        for (i = 0; i < npr; ++i) {
            P[index--] = P[index1--];
        }
        System.arraycopy(xnext, 0, P, 0, r);
        return P;
    }

    private static int validate(int ip, int iq, int ir, int np, int nrbar) {
        if (ip == 0 && iq == 0) {
            return 4;
        }
        if (np != ir * (ir + 1) / 2) {
            return 6;
        }
        if (nrbar != np * (np - 1) / 2) {
            return 7;
        }
        return 0;
    }

    private static void inclu2(int np, double[] xnext, double[] xrow, double ynext, double[] d, double[] rbar, double[] thetab) {
        System.arraycopy(xnext, 0, xrow, 0, np);
        int ithisr = 0;
        double y = ynext;
        double wt = 1.0;
        for (int i = 0; i < np; ++i) {
            if (xrow[i] != 0.0) {
                double xk;
                double dpi;
                double xi = xrow[i];
                double di = d[i];
                d[i] = dpi = di + wt * xi * xi;
                double cbar = di / dpi;
                double sbar = wt * xi / dpi;
                wt = cbar * wt;
                if (i != np - 1) {
                    int i1;
                    for (int k = i1 = i + 1; k < np; ++k) {
                        xk = xrow[k];
                        double rbthis = rbar[ithisr];
                        xrow[k] = xk - xi * rbthis;
                        rbar[ithisr++] = cbar * rbthis + sbar * xk;
                    }
                }
                xk = y;
                y = xk - xi * thetab[i];
                thetab[i] = cbar * thetab[i] + sbar * xk;
                if (di != 0.0) continue;
                return;
            }
            ithisr = ithisr + np - i - 1;
        }
    }

    private static void regres(int np, int nrbar, double[] rbar, double[] thetab, double[] beta) {
        int ithisr = nrbar - 1;
        int im = np - 1;
        for (int i = 0; i < np; ++i) {
            double bi = thetab[im];
            if (im != np - 1) {
                int i1 = i;
                int jm = np - 1;
                for (int j = 0; j < i1; ++j) {
                    bi -= rbar[ithisr] * beta[jm];
                    --ithisr;
                    --jm;
                }
            }
            beta[im] = bi;
            --im;
        }
    }

    static double[] unpack(double[] triangularMatrix) {
        int j;
        int c = triangularMatrix.length;
        int r = (-1 + (int)Math.sqrt(1 + 8 * c)) / 2;
        double[] full = new double[r * r];
        int k = 0;
        int indext = 0;
        int i = 0;
        while (i < r) {
            for (j = 0; j < r - k; ++j) {
                full[j + k + i * r] = triangularMatrix[indext++];
            }
            ++i;
            ++k;
        }
        for (i = 0; i < r - 1; ++i) {
            for (j = i + 1; j < r; ++j) {
                full[i + r * j] = full[j + i * r];
            }
        }
        return full;
    }

    double[] predictionError() {
        return (double[])this.predictionError.clone();
    }

    double ssq() {
        return this.kalmanOutput.ssq;
    }

    double logLikelihood() {
        return this.kalmanOutput.logLikelihood;
    }

    KalmanOutput output() {
        return this.kalmanOutput;
    }

    private KalmanOutput filter() {
        this.predictionError[0] = this.y[0];
        double f = this.predictionErrorVariance[0] = this.predictedCovarianceFirstColumn.get(0);
        double ssq = this.predictionError[0] * this.predictionError[0] / f;
        double sumlog = Math.log(f);
        DenseMatrix64F newInfo = this.predictedCovarianceFirstColumn.copy();
        CommonOps.scale((double)this.predictionError[0], (D1Matrix64F)newInfo);
        CommonOps.divide((D1Matrix64F)newInfo, (double)this.predictionErrorVariance[0]);
        CommonOps.add((D1Matrix64F)this.predictedState, (D1Matrix64F)newInfo, (D1Matrix64F)this.filteredState);
        DenseMatrix64F adjustedPredictionCovariance = new DenseMatrix64F(this.r, this.r);
        CommonOps.multOuter((RowD1Matrix64F)this.predictedCovarianceFirstColumn, (RowD1Matrix64F)adjustedPredictionCovariance);
        CommonOps.divide((D1Matrix64F)adjustedPredictionCovariance, (double)this.predictionErrorVariance[0]);
        CommonOps.subtract((D1Matrix64F)this.predictedStateCovariance, (D1Matrix64F)adjustedPredictionCovariance, (D1Matrix64F)this.filteredStateCovariance);
        DenseMatrix64F filteredCovarianceTransition = new DenseMatrix64F(this.r, this.r);
        DenseMatrix64F stateCovarianceTransition = new DenseMatrix64F(this.r, this.r);
        DenseMatrix64F transitionTranspose = this.transitionFunction.copy();
        CommonOps.transpose((DenseMatrix64F)transitionTranspose);
        this.predictionError[0] = this.predictionError[0] / Math.sqrt(f);
        int t = 1;
        while (t < this.y.length) {
            CommonOps.mult((RowD1Matrix64F)this.transitionFunction, (RowD1Matrix64F)this.filteredState, (RowD1Matrix64F)this.predictedState);
            CommonOps.mult((RowD1Matrix64F)this.transitionFunction, (RowD1Matrix64F)this.filteredStateCovariance, (RowD1Matrix64F)filteredCovarianceTransition);
            CommonOps.mult((RowD1Matrix64F)filteredCovarianceTransition, (RowD1Matrix64F)transitionTranspose, (RowD1Matrix64F)stateCovarianceTransition);
            CommonOps.add((D1Matrix64F)stateCovarianceTransition, (D1Matrix64F)this.stateDisturbance, (D1Matrix64F)this.predictedStateCovariance);
            this.predictionError[t] = this.y[t] - this.predictedState.get(0);
            CommonOps.extractColumn((DenseMatrix64F)this.predictedStateCovariance, (int)0, (DenseMatrix64F)this.predictedCovarianceFirstColumn);
            f = this.predictionErrorVariance[t] = this.predictedCovarianceFirstColumn.get(0);
            ssq += this.predictionError[t] * this.predictionError[t] / f;
            sumlog += Math.log(f);
            newInfo = this.predictedCovarianceFirstColumn.copy();
            CommonOps.scale((double)this.predictionError[t], (D1Matrix64F)newInfo);
            CommonOps.divide((D1Matrix64F)newInfo, (double)f);
            CommonOps.add((D1Matrix64F)this.predictedState, (D1Matrix64F)newInfo, (D1Matrix64F)this.filteredState);
            CommonOps.multOuter((RowD1Matrix64F)this.predictedCovarianceFirstColumn, (RowD1Matrix64F)adjustedPredictionCovariance);
            CommonOps.divide((D1Matrix64F)adjustedPredictionCovariance, (double)f);
            CommonOps.subtract((D1Matrix64F)this.predictedStateCovariance, (D1Matrix64F)adjustedPredictionCovariance, (D1Matrix64F)this.filteredStateCovariance);
            int n = t++;
            this.predictionError[n] = this.predictionError[n] / Math.sqrt(f);
        }
        return new KalmanOutput(this.y.length, ssq, sumlog, this.predictionError);
    }

    private DenseMatrix64F initializePredictedCovariance(ArmaStateSpace ss) {
        double[] P = ArmaKalmanFilter.getInitialStateCovariance(ss.arParams(), ss.maParams());
        return new DenseMatrix64F(ss.r(), ss.r(), true, ArmaKalmanFilter.unpack(P));
    }

    static class KalmanOutput {
        private final int n;
        private final double ssq;
        private final double sumlog;
        private final double sigma2;
        private final double logLikelihood;
        private final double[] residuals;

        KalmanOutput(int n, double ssq, double sumlog, double[] residuals) {
            this.n = n;
            this.ssq = ssq;
            this.sumlog = sumlog;
            this.sigma2 = ssq / (double)n;
            this.logLikelihood = (double)(-n) / 2.0 * (Math.log(Math.PI * 2 * this.sigma2) + 1.0) - 0.5 * sumlog;
            this.residuals = (double[])residuals.clone();
        }

        int n() {
            return this.n;
        }

        double ssq() {
            return this.ssq;
        }

        double sumLog() {
            return this.sumlog;
        }

        double sigma2() {
            return this.sigma2;
        }

        double logLikelihood() {
            return this.logLikelihood;
        }

        double[] residuals() {
            return (double[])this.residuals.clone();
        }
    }
}

