/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.regression;

import com.github.signaflo.data.Range;
import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.model.regression.TimeSeriesLinearRegression;
import com.github.signaflo.timeseries.model.regression.TimeSeriesLinearRegressionModel;
import lombok.NonNull;

public final class TimeSeriesLinearRegressionBuilder {
    private double[][] timeBasedPredictors = new double[0][0];
    private double[][] externalRegressors = new double[0][0];
    private TimeSeries response;
    private TimeSeriesLinearRegression.Intercept intercept = TimeSeriesLinearRegression.Intercept.INCLUDE;
    private TimeSeriesLinearRegression.TimeTrend timeTrend = TimeSeriesLinearRegression.TimeTrend.INCLUDE;
    private TimeSeriesLinearRegression.Seasonal seasonal = TimeSeriesLinearRegression.Seasonal.EXCLUDE;
    private TimePeriod seasonalCycle = TimePeriod.oneYear();

    public final TimeSeriesLinearRegressionBuilder from(TimeSeriesLinearRegression regression) {
        this.externalRegressors = DoubleFunctions.copy((double[][])regression.predictors());
        this.response = regression.timeSeriesResponse();
        this.intercept = regression.intercept();
        this.timeTrend = regression.timeTrend();
        this.seasonal = regression.seasonal();
        this.seasonalCycle = regression.seasonalCycle();
        return this;
    }

    public TimeSeriesLinearRegressionBuilder externalRegressors(double[] ... regressors) {
        int i;
        if (regressors == null) {
            throw new NullPointerException("regressors");
        }
        int currentCols = this.externalRegressors.length;
        int currentRows = 0;
        if (currentCols > 0) {
            currentRows = this.externalRegressors[0].length;
        } else if (regressors.length > 0) {
            currentRows = regressors[0].length;
        }
        double[][] newPredictors = new double[currentCols + regressors.length][currentRows];
        for (i = 0; i < currentCols; ++i) {
            System.arraycopy(this.externalRegressors[i], 0, newPredictors[i], 0, currentRows);
        }
        for (i = 0; i < regressors.length; ++i) {
            newPredictors[i + currentCols] = (double[])regressors[i].clone();
        }
        this.externalRegressors = newPredictors;
        return this;
    }

    private TimeSeriesLinearRegressionBuilder timeBasedPredictors(double[] ... predictors) {
        int i;
        if (predictors == null) {
            throw new NullPointerException("predictors");
        }
        int currentCols = this.timeBasedPredictors.length;
        int currentRows = 0;
        if (currentCols > 0) {
            currentRows = this.timeBasedPredictors[0].length;
        } else if (predictors.length > 0) {
            currentRows = predictors[0].length;
        }
        double[][] newPredictors = new double[currentCols + predictors.length][currentRows];
        for (i = 0; i < currentCols; ++i) {
            System.arraycopy(this.timeBasedPredictors[i], 0, newPredictors[i], 0, currentRows);
        }
        for (i = 0; i < predictors.length; ++i) {
            newPredictors[i + currentCols] = (double[])predictors[i].clone();
        }
        this.timeBasedPredictors = newPredictors;
        return this;
    }

    public TimeSeriesLinearRegressionBuilder externalRegressors(@NonNull Matrix regressors) {
        if (regressors == null) {
            throw new NullPointerException("regressors");
        }
        this.externalRegressors(regressors.data2D(Matrix.Layout.BY_COLUMN));
        return this;
    }

    public TimeSeriesLinearRegressionBuilder response(@NonNull TimeSeries response) {
        if (response == null) {
            throw new NullPointerException("response");
        }
        this.response = response;
        return this;
    }

    public TimeSeriesLinearRegressionBuilder hasIntercept(@NonNull TimeSeriesLinearRegression.Intercept intercept) {
        if (intercept == null) {
            throw new NullPointerException("intercept");
        }
        this.intercept = intercept;
        return this;
    }

    public TimeSeriesLinearRegressionBuilder timeTrend(@NonNull TimeSeriesLinearRegression.TimeTrend timeTrend) {
        if (timeTrend == null) {
            throw new NullPointerException("timeTrend");
        }
        this.timeTrend = timeTrend;
        return this;
    }

    public TimeSeriesLinearRegressionBuilder seasonal(@NonNull TimeSeriesLinearRegression.Seasonal seasonal) {
        if (seasonal == null) {
            throw new NullPointerException("seasonal");
        }
        this.seasonal = seasonal;
        return this;
    }

    public TimeSeriesLinearRegressionBuilder seasonalCycle(@NonNull TimePeriod seasonalCycle) {
        if (seasonalCycle == null) {
            throw new NullPointerException("seasonalCycle");
        }
        this.seasonalCycle = seasonalCycle;
        return this;
    }

    public TimeSeriesLinearRegression build() {
        if (this.response == null) {
            throw new IllegalStateException("A time series linear regression model must have a non-null response variable.");
        }
        if (this.timeTrend.include()) {
            this.timeBasedPredictors(new double[][]{Range.inclusiveRange(1.0, this.response.size()).asArray()});
        }
        if (this.seasonal.include()) {
            int seasonalFrequency = (int)this.response.timePeriod().frequencyPer(this.seasonalCycle);
            int periodOffset = 0;
            double[][] seasonalRegressors = TimeSeriesLinearRegressionModel.getSeasonalRegressors(this.response.size(), seasonalFrequency, periodOffset);
            this.timeBasedPredictors(seasonalRegressors);
        }
        return new TimeSeriesLinearRegressionModel(this);
    }

    double[][] timeBasedPredictors() {
        return this.timeBasedPredictors;
    }

    double[][] externalRegressors() {
        return this.externalRegressors;
    }

    TimeSeries response() {
        return this.response;
    }

    TimeSeriesLinearRegression.Intercept intercept() {
        return this.intercept;
    }

    TimeSeriesLinearRegression.TimeTrend timeTrend() {
        return this.timeTrend;
    }

    TimeSeriesLinearRegression.Seasonal seasonal() {
        return this.seasonal;
    }

    TimePeriod seasonalCycle() {
        return this.seasonalCycle;
    }
}

