/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.model.regression;

import com.github.signaflo.data.Range;
import com.github.signaflo.data.regression.MultipleLinearRegression;
import com.github.signaflo.data.regression.MultipleLinearRegressionPredictor;
import com.github.signaflo.data.regression.MultipleRegressionBuilder;
import com.github.signaflo.math.linear.doubles.Matrix;
import com.github.signaflo.math.linear.doubles.Vector;
import com.github.signaflo.math.operations.DoubleFunctions;
import com.github.signaflo.timeseries.TimePeriod;
import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.forecast.Forecast;
import com.github.signaflo.timeseries.model.Model;
import com.github.signaflo.timeseries.model.regression.TimeSeriesLinearRegression;
import com.github.signaflo.timeseries.model.regression.TimeSeriesLinearRegressionBuilder;
import com.github.signaflo.timeseries.model.regression.TimeSeriesRegressionForecaster;
import java.util.Arrays;

final class TimeSeriesLinearRegressionModel
implements TimeSeriesLinearRegression,
Model {
    private final MultipleLinearRegression regression;
    private final TimeSeries timeSeries;
    private final TimePeriod seasonalCycle;
    private final TimeSeriesLinearRegression.Intercept intercept;
    private final TimeSeriesLinearRegression.TimeTrend timeTrend;
    private final TimeSeriesLinearRegression.Seasonal seasonal;
    private final double[][] externalRegressors;

    TimeSeriesLinearRegressionModel(TimeSeriesLinearRegressionBuilder timeSeriesRegressionBuilder) {
        this.timeSeries = timeSeriesRegressionBuilder.response();
        this.seasonalCycle = timeSeriesRegressionBuilder.seasonalCycle();
        this.externalRegressors = timeSeriesRegressionBuilder.externalRegressors();
        double[][] allPredictors = DoubleFunctions.combine((double[][][])new double[][][]{timeSeriesRegressionBuilder.timeBasedPredictors(), timeSeriesRegressionBuilder.externalRegressors()});
        MultipleRegressionBuilder regressionBuilder = MultipleLinearRegression.builder();
        regressionBuilder.hasIntercept(timeSeriesRegressionBuilder.intercept().include()).predictors(allPredictors).response(this.timeSeries.asArray());
        this.regression = regressionBuilder.build();
        this.intercept = timeSeriesRegressionBuilder.intercept();
        this.timeTrend = timeSeriesRegressionBuilder.timeTrend();
        this.seasonal = timeSeriesRegressionBuilder.seasonal();
    }

    @Override
    public double[][] predictors() {
        return DoubleFunctions.copy((double[][])this.externalRegressors);
    }

    @Override
    public double[][] XtXInverse() {
        return this.regression.XtXInverse();
    }

    @Override
    public double[][] designMatrix() {
        return this.regression.designMatrix();
    }

    @Override
    public double[] response() {
        return this.regression.response();
    }

    @Override
    public double[] beta() {
        return this.regression.beta();
    }

    @Override
    public double[] standardErrors() {
        return this.regression.standardErrors();
    }

    @Override
    public double[] fitted() {
        return this.regression.fitted();
    }

    @Override
    public Forecast forecast(int steps, double alpha) {
        MultipleLinearRegressionPredictor predictor = MultipleLinearRegressionPredictor.from(this);
        Vector beta = Vector.from((double[])this.beta());
        Matrix predictionMatrix = this.getPredictionMatrix(steps);
        TimeSeriesRegressionForecaster forecaster = new TimeSeriesRegressionForecaster(this.timeSeries, predictor, beta, predictionMatrix);
        return forecaster.forecast(steps, alpha);
    }

    @Override
    public TimeSeries observations() {
        return this.timeSeriesResponse();
    }

    @Override
    public TimeSeries fittedSeries() {
        return null;
    }

    @Override
    public double sigma2() {
        return this.regression.sigma2();
    }

    @Override
    public boolean hasIntercept() {
        return this.regression.hasIntercept();
    }

    @Override
    public TimePeriod seasonalCycle() {
        return this.seasonalCycle;
    }

    @Override
    public TimeSeries timeSeriesResponse() {
        return this.timeSeries;
    }

    @Override
    public TimeSeriesLinearRegression.Intercept intercept() {
        return this.intercept;
    }

    @Override
    public TimeSeriesLinearRegression.TimeTrend timeTrend() {
        return this.timeTrend;
    }

    @Override
    public TimeSeriesLinearRegression.Seasonal seasonal() {
        return this.seasonal;
    }

    @Override
    public int seasonalFrequency() {
        return (int)this.timeSeries.timePeriod().frequencyPer(this.seasonalCycle);
    }

    private static double[] getIthSeasonalRegressor(int nrows, int startRow, int seasonalFrequency) {
        double[] regressor = new double[nrows];
        for (int j = 0; j < regressor.length - startRow; j += seasonalFrequency) {
            regressor[j + startRow] = 1.0;
        }
        return regressor;
    }

    static double[][] getSeasonalRegressors(int nrows, int seasonalFrequency, int periodOffset) {
        int ncols = seasonalFrequency - 1;
        double[][] seasonalRegressors = new double[ncols][nrows];
        for (int i = 0; i < ncols; ++i) {
            int startRow = Math.floorMod(i + 1 - periodOffset, seasonalFrequency);
            seasonalRegressors[i] = TimeSeriesLinearRegressionModel.getIthSeasonalRegressor(nrows, startRow, seasonalFrequency);
        }
        return seasonalRegressors;
    }

    private Matrix getPredictionMatrix(int steps) {
        int intercept = this.intercept().asInt();
        int timeTrend = this.timeTrend().asInt();
        int seasonal = this.seasonal().asInt();
        int seasonalFrequency = this.seasonalFrequency();
        int ncols = intercept + timeTrend + (seasonalFrequency - 1) * seasonal;
        double[][] designMatrix = new double[ncols][steps];
        if (this.intercept().include()) {
            designMatrix[0] = DoubleFunctions.fill((int)steps, (double)1.0);
        }
        if (this.timeTrend().include()) {
            int startTime = this.response().length + 1;
            int endTime = startTime + steps;
            designMatrix[intercept] = Range.exclusiveRange(startTime, endTime).asArray();
        }
        if (this.seasonal().include()) {
            int periodOffset = this.response().length % seasonalFrequency;
            double[][] seasonalMatrix = TimeSeriesLinearRegressionModel.getSeasonalRegressors(steps, seasonalFrequency, periodOffset);
            for (int i = 0; i < seasonalMatrix.length; ++i) {
                designMatrix[i + intercept + timeTrend] = seasonalMatrix[i];
            }
        }
        return Matrix.create((Matrix.Layout)Matrix.Layout.BY_COLUMN, (double[][])designMatrix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeSeriesLinearRegressionModel that = (TimeSeriesLinearRegressionModel)o;
        if (!this.timeSeries.equals(that.timeSeries)) {
            return false;
        }
        if (!this.seasonalCycle.equals(that.seasonalCycle)) {
            return false;
        }
        if (this.intercept != that.intercept) {
            return false;
        }
        if (this.timeTrend != that.timeTrend) {
            return false;
        }
        if (this.seasonal != that.seasonal) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.externalRegressors, (Object[])that.externalRegressors);
    }

    public int hashCode() {
        int result = this.timeSeries.hashCode();
        result = 31 * result + this.seasonalCycle.hashCode();
        result = 31 * result + this.intercept.hashCode();
        result = 31 * result + this.timeTrend.hashCode();
        result = 31 * result + this.seasonal.hashCode();
        result = 31 * result + Arrays.deepHashCode((Object[])this.externalRegressors);
        return result;
    }

    public String toString() {
        return "TimeSeriesLinearRegressionModel(regression=" + this.regression + ", timeSeries=" + this.timeSeries + ", seasonalCycle=" + this.seasonalCycle + ", intercept=" + (Object)((Object)this.intercept) + ", timeTrend=" + (Object)((Object)this.timeTrend) + ", seasonal=" + (Object)((Object)this.seasonal) + ", externalRegressors=" + Arrays.deepToString((Object[])this.externalRegressors) + ")";
    }
}

