/*
 * Decompiled with CFR 0.152.
 */
package com.github.signaflo.timeseries.operators;

import com.github.signaflo.timeseries.TimeSeries;
import com.github.signaflo.timeseries.operators.LagOperator;
import com.github.signaflo.timeseries.operators.LagPolynomial;

final class MovingAveragePolynomial
extends LagPolynomial {
    MovingAveragePolynomial(double ... parameters) {
        super(parameters);
    }

    @Override
    public double solve(TimeSeries residualSeries, int index) {
        double value = 0.0;
        for (int i = 0; i < this.parameters.length; ++i) {
            value += this.parameters[i] * LagOperator.apply(residualSeries, index, i + 1);
        }
        return value;
    }

    @Override
    public double solve(double[] residualSeries, int index) {
        double value = 0.0;
        for (int i = 0; i < Math.min(this.parameters.length, index); ++i) {
            value += this.parameters[i] * LagOperator.apply(residualSeries, index, i + 1);
        }
        return value;
    }
}

