/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core;

import com.github.sommeri.less4j.core.ExtendedStringBuilder;
import com.github.sommeri.less4j.core.NotACssException;
import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.CharsetDeclaration;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.Comment;
import com.github.sommeri.less4j.core.ast.ComposedExpression;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.ExpressionOperator;
import com.github.sommeri.less4j.core.ast.FontFace;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.IdSelector;
import com.github.sommeri.less4j.core.ast.IdentifierExpression;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaExpression;
import com.github.sommeri.less4j.core.ast.MediaExpressionFeature;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.Medium;
import com.github.sommeri.less4j.core.ast.MediumModifier;
import com.github.sommeri.less4j.core.ast.MediumType;
import com.github.sommeri.less4j.core.ast.NamedColorExpression;
import com.github.sommeri.less4j.core.ast.NamedExpression;
import com.github.sommeri.less4j.core.ast.Nth;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.ast.PseudoClass;
import com.github.sommeri.less4j.core.ast.PseudoElement;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorAttribute;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SelectorOperator;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.ast.StyleSheet;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;

class CssPrinter {
    private final ExtendedStringBuilder builder;
    private static final DecimalFormat FORMATTER = new DecimalFormat("#.##################");

    public CssPrinter(ExtendedStringBuilder builder) {
        this.builder = builder;
    }

    public boolean append(ASTCssNode node) {
        if (node == null) {
            return false;
        }
        this.appendComments(node.getOpeningComments(), true);
        boolean result = this.switchOnType(node);
        this.appendComments(node.getTrailingComments(), false);
        return result;
    }

    public boolean switchOnType(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                return this.appendRuleset((RuleSet)node);
            }
            case DECLARATIONS_BODY: {
                return this.appendBody((RuleSetsBody)node);
            }
            case CSS_CLASS: {
                return this.appendCssClass((CssClass)node);
            }
            case PSEUDO_CLASS: {
                return this.appendPseudoClass((PseudoClass)node);
            }
            case PSEUDO_ELEMENT: {
                return this.appendPseudoElement((PseudoElement)node);
            }
            case NTH: {
                return this.appendNth((Nth)node);
            }
            case SELECTOR: {
                return this.appendSelector((Selector)node);
            }
            case SIMPLE_SELECTOR: {
                return this.appendSimpleSelector((SimpleSelector)node);
            }
            case SELECTOR_OPERATOR: {
                return this.appendSelectorOperator((SelectorOperator)node);
            }
            case SELECTOR_COMBINATOR: {
                return this.appendSelectorCombinator((SelectorCombinator)node);
            }
            case SELECTOR_ATTRIBUTE: {
                return this.appendSelectorAttribute((SelectorAttribute)node);
            }
            case ID_SELECTOR: {
                return this.appendIdSelector((IdSelector)node);
            }
            case CHARSET_DECLARATION: {
                return this.appendCharsetDeclaration((CharsetDeclaration)node);
            }
            case FONT_FACE: {
                return this.appendFontFace((FontFace)node);
            }
            case NAMED_EXPRESSION: {
                return this.appendNamedExpression((NamedExpression)node);
            }
            case COMPOSED_EXPRESSION: {
                return this.appendComposedExpression((ComposedExpression)node);
            }
            case EXPRESSION_OPERATOR: {
                return this.appendExpressionOperator((ExpressionOperator)node);
            }
            case STRING_EXPRESSION: {
                return this.appendCssString((CssString)node);
            }
            case NUMBER: {
                return this.appendNumberExpression((NumberExpression)node);
            }
            case IDENTIFIER_EXPRESSION: {
                return this.appendIdentifierExpression((IdentifierExpression)node);
            }
            case COLOR_EXPRESSION: {
                return this.appendColorExpression((ColorExpression)node);
            }
            case FUNCTION: {
                return this.appendFunctionExpression((FunctionExpression)node);
            }
            case DECLARATION: {
                return this.appendDeclaration((Declaration)node);
            }
            case MEDIA: {
                return this.appendMedia((Media)node);
            }
            case MEDIA_QUERY: {
                return this.appendMediaQuery((MediaQuery)node);
            }
            case MEDIUM: {
                return this.appendMedium((Medium)node);
            }
            case MEDIUM_MODIFIER: {
                return this.appendMediumModifier((MediumModifier)node);
            }
            case MEDIUM_TYPE: {
                return this.appendMediumType((MediumType)node);
            }
            case MEDIA_EXPRESSION: {
                return this.appendMediaExpression((MediaExpression)node);
            }
            case MEDIUM_EX_FEATURE: {
                return this.appendMediaExpressionFeature((MediaExpressionFeature)node);
            }
            case STYLE_SHEET: {
                return this.appendStyleSheet((StyleSheet)node);
            }
            case PARENTHESES_EXPRESSION: 
            case SIGNED_EXPRESSION: 
            case VARIABLE: 
            case NESTED_RULESET: 
            case INDIRECT_VARIABLE: 
            case VARIABLE_DECLARATION: {
                throw new NotACssException(node);
            }
        }
        throw new IllegalStateException("Unknown: " + (Object)((Object)node.getType()));
    }

    private boolean appendNth(Nth node) {
        switch (node.getForm()) {
            case EVEN: {
                this.builder.append("even");
                return true;
            }
            case ODD: {
                this.builder.append("odd");
                return true;
            }
            case STANDARD: {
                if (node.getRepeater() != null) {
                    this.append(node.getRepeater());
                }
                if (node.getMod() == null) break;
                this.append(node.getMod());
            }
        }
        return true;
    }

    private void appendComments(List<Comment> comments, boolean ensureSeparator) {
        if (comments == null || comments.isEmpty()) {
            return;
        }
        this.builder.ensureSeparator();
        for (Comment comment : comments) {
            this.builder.append(comment.getComment());
            if (!comment.hasNewLine()) continue;
            this.builder.newLine();
        }
        if (ensureSeparator) {
            this.builder.ensureSeparator();
        }
    }

    public boolean appendFontFace(FontFace node) {
        this.builder.append("@font-face {").newLine();
        this.builder.increaseIndentationLevel();
        this.appendAllChilds(node);
        this.builder.decreaseIndentationLevel();
        this.builder.append("}");
        return true;
    }

    public boolean appendCharsetDeclaration(CharsetDeclaration node) {
        this.builder.append("@charset").ensureSeparator();
        this.builder.append(node.getCharset());
        this.builder.append(";");
        return true;
    }

    public boolean appendIdSelector(IdSelector node) {
        this.builder.append("#");
        this.builder.append(node.getName());
        return true;
    }

    public boolean appendSelectorAttribute(SelectorAttribute node) {
        this.builder.append("[");
        this.builder.append(node.getName());
        this.append(node.getOperator());
        this.builder.appendIgnoreNull(node.getValue());
        this.builder.append("]");
        return true;
    }

    private boolean appendSelectorOperator(SelectorOperator operator) {
        switch (operator.getOperator()) {
            case NONE: {
                break;
            }
            case EQUALS: {
                this.builder.append("=");
                break;
            }
            case INCLUDES: {
                this.builder.append("~=");
                break;
            }
            case SPECIAL_PREFIX: {
                this.builder.append("|=");
                break;
            }
            case PREFIXMATCH: {
                this.builder.append("^=");
                break;
            }
            case SUFFIXMATCH: {
                this.builder.append("$=");
                break;
            }
            case SUBSTRINGMATCH: {
                this.builder.append("*=");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown: " + operator);
            }
        }
        return true;
    }

    public boolean appendPseudoClass(PseudoClass node) {
        this.builder.append(":");
        this.builder.append(node.getName());
        if (node.hasParameters()) {
            this.builder.append("(");
            this.append(node.getParameter());
            this.builder.append(")");
        }
        return true;
    }

    public boolean appendPseudoElement(PseudoElement node) {
        this.builder.append(":");
        if (!node.isLevel12Form()) {
            this.builder.append(":");
        }
        this.builder.append(node.getName());
        return true;
    }

    public boolean appendStyleSheet(StyleSheet styleSheet) {
        this.appendAllChilds(styleSheet);
        return true;
    }

    public boolean appendRuleset(RuleSet ruleSet) {
        if (ruleSet.hasEmptyBody()) {
            return false;
        }
        this.appendSelectors(ruleSet.getSelectors());
        this.append(ruleSet.getBody());
        return true;
    }

    public boolean appendBody(RuleSetsBody body) {
        if (body.isEmpty()) {
            return false;
        }
        this.builder.ensureSeparator().append("{").newLine();
        this.builder.increaseIndentationLevel();
        for (ASTCssNode declaration : body.getChilds()) {
            this.append(declaration);
            this.builder.ensureNewLine();
        }
        this.appendComments(body.getOrphanComments(), false);
        this.builder.decreaseIndentationLevel();
        this.builder.append("}");
        return true;
    }

    public boolean appendDeclaration(Declaration declaration) {
        this.builder.appendIgnoreNull(declaration.getName());
        this.builder.append(":").ensureSeparator();
        if (declaration.getExpression() != null) {
            this.append(declaration.getExpression());
        }
        if (declaration.isImportant()) {
            this.builder.ensureSeparator().append("!important");
        }
        this.builder.appendIgnoreNull(";");
        return true;
    }

    public boolean appendMedia(Media node) {
        this.builder.append("@media");
        this.appendMediums(node.getMediums());
        this.builder.ensureSeparator().append("{").newLine();
        this.builder.increaseIndentationLevel();
        Iterator<ASTCssNode> declarations = node.getDeclarations().iterator();
        List<ASTCssNode> ruleSets = node.getRuleSets();
        while (declarations.hasNext()) {
            ASTCssNode body = declarations.next();
            this.append(body);
            if (!declarations.hasNext() && !ruleSets.isEmpty()) continue;
            this.builder.ensureNewLine();
        }
        for (ASTCssNode body : ruleSets) {
            this.append(body);
            this.builder.ensureNewLine();
        }
        this.builder.decreaseIndentationLevel();
        this.builder.append("}");
        return true;
    }

    private void appendMediums(List<MediaQuery> mediums) {
        if (mediums == null || mediums.isEmpty()) {
            return;
        }
        boolean needComma = false;
        for (MediaQuery mediaQuery : mediums) {
            if (needComma) {
                this.builder.append(",").ensureSeparator();
            }
            this.append(mediaQuery);
            needComma = true;
        }
    }

    public boolean appendMediaQuery(MediaQuery mediaQuery) {
        this.builder.ensureSeparator();
        this.append(mediaQuery.getMedium());
        boolean needSeparator = mediaQuery.getMedium() != null;
        for (MediaExpression mediaExpression : mediaQuery.getExpressions()) {
            if (needSeparator) {
                this.builder.ensureSeparator().append("and");
            }
            this.append(mediaExpression);
            needSeparator = true;
        }
        return true;
    }

    public boolean appendMedium(Medium medium) {
        this.append(medium.getModifier());
        this.append(medium.getMediumType());
        return true;
    }

    public boolean appendMediumModifier(MediumModifier modifier) {
        MediumModifier.Modifier kind = modifier.getModifier();
        switch (kind) {
            case ONLY: {
                this.builder.ensureSeparator().append("only");
                break;
            }
            case NOT: {
                this.builder.ensureSeparator().append("not");
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown modifier type.");
            }
        }
        return true;
    }

    public boolean appendMediumType(MediumType medium) {
        this.builder.ensureSeparator().append(medium.getName());
        return true;
    }

    public boolean appendMediaExpression(MediaExpression expression) {
        this.builder.ensureSeparator().append("(");
        this.append(expression.getFeature());
        if (expression.getExpression() != null) {
            this.builder.append(":").ensureSeparator();
            this.append(expression.getExpression());
        }
        this.builder.append(")");
        return true;
    }

    public boolean appendMediaExpressionFeature(MediaExpressionFeature feature) {
        this.builder.append(feature.getFeature());
        return true;
    }

    public boolean appendNamedExpression(NamedExpression expression) {
        this.builder.append(expression.getName());
        this.builder.append("=");
        this.append(expression.getExpression());
        return true;
    }

    public boolean appendComposedExpression(ComposedExpression expression) {
        this.append(expression.getLeft());
        this.append(expression.getOperator());
        this.append(expression.getRight());
        return true;
    }

    public boolean appendExpressionOperator(ExpressionOperator operator) {
        switch (operator.getOperator()) {
            case COMMA: {
                this.builder.append(",").ensureSeparator();
                break;
            }
            case SOLIDUS: {
                this.builder.append("/");
                break;
            }
            case STAR: {
                this.builder.append("*");
                break;
            }
            case EMPTY_OPERATOR: {
                this.builder.ensureSeparator();
                break;
            }
            case PLUS: {
                this.builder.append("+");
                break;
            }
            case MINUS: {
                this.builder.ensureSeparator().append("-");
                break;
            }
            default: {
                throw new IllegalStateException("Unknown: " + operator);
            }
        }
        return true;
    }

    public boolean appendCssString(CssString expression) {
        String quoteType = expression.getQuoteType();
        this.builder.append(quoteType + expression.getValue() + quoteType);
        return true;
    }

    public boolean appendIdentifierExpression(IdentifierExpression expression) {
        this.builder.append(expression.getValue());
        return true;
    }

    private boolean appendColorExpression(ColorExpression expression) {
        if (expression instanceof NamedColorExpression) {
            NamedColorExpression named = (NamedColorExpression)expression;
            this.builder.append(named.getColorName());
        } else {
            this.builder.append(expression.getValue());
        }
        return true;
    }

    private boolean appendFunctionExpression(FunctionExpression node) {
        this.builder.append(node.getName());
        this.builder.append("(");
        this.append(node.getParameter());
        this.builder.append(")");
        return true;
    }

    private boolean appendNumberExpression(NumberExpression node) {
        if (node.hasOriginalString()) {
            this.builder.append(node.getOriginalString());
        } else {
            if (node.hasExpliciteSign()) {
                if (0.0 < node.getValueAsDouble()) {
                    this.builder.append("+");
                } else {
                    this.builder.append("-");
                }
            }
            this.builder.append(this.format(node.getValueAsDouble()) + node.getSuffix());
        }
        return true;
    }

    private String format(Double valueAsDouble) {
        return FORMATTER.format(valueAsDouble);
    }

    public void appendSelectors(List<Selector> selectors) {
        Iterator<Selector> iterator = selectors.iterator();
        while (iterator.hasNext()) {
            Selector selector = iterator.next();
            this.append(selector);
            if (!iterator.hasNext()) continue;
            this.builder.append(",").newLine();
        }
    }

    public boolean appendSelector(Selector selector) {
        if (selector.hasLeadingCombinator()) {
            this.append(selector.getLeadingCombinator());
        }
        if (!selector.isCombined()) {
            this.append(selector.getHead());
            return true;
        }
        this.append(selector.getHead());
        this.append(selector.getRight());
        return true;
    }

    private boolean appendSimpleSelector(SimpleSelector selector) {
        this.appendSimpleSelectorHead(selector);
        this.appendSimpleSelectorTail(selector);
        return true;
    }

    private void appendSimpleSelectorTail(SimpleSelector selector) {
        List<ASTCssNode> allChilds = selector.getSubsequent();
        for (ASTCssNode astCssNode : allChilds) {
            this.append(astCssNode);
        }
    }

    private boolean appendCssClass(CssClass cssClass) {
        this.builder.append(".").append(cssClass.getName());
        return true;
    }

    private void appendSimpleSelectorHead(SimpleSelector selector) {
        this.builder.ensureSeparator();
        if (selector.isStar()) {
            if (!selector.isEmptyForm()) {
                this.builder.append("*");
            }
        } else {
            this.builder.appendIgnoreNull(selector.getElementName());
        }
    }

    public boolean appendSelectorCombinator(SelectorCombinator combinator) {
        switch (combinator.getCombinator()) {
            case ADJACENT_SIBLING: {
                this.builder.ensureSeparator().append("+");
                break;
            }
            case CHILD: {
                this.builder.ensureSeparator().append(">");
                break;
            }
            case GENERAL_SIBLING: {
                this.builder.ensureSeparator().append("~");
                break;
            }
            case DESCENDANT: {
                this.builder.ensureSeparator();
            }
        }
        return true;
    }

    private void appendAllChilds(ASTCssNode node) {
        List<? extends ASTCssNode> allChilds = node.getChilds();
        for (ASTCssNode aSTCssNode : allChilds) {
            if (!this.append(aSTCssNode)) continue;
            this.builder.ensureNewLine();
        }
    }
}

