/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.Declaration;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class Media
extends Body<ASTCssNode> {
    private List<MediaQuery> mediums;

    public Media(HiddenTokenAwareTree token) {
        super(token);
    }

    public List<ASTCssNode> getDeclarations() {
        return this.membersByType(ASTCssNodeType.DECLARATION);
    }

    public List<ASTCssNode> getRuleSets() {
        return this.membersByType(ASTCssNodeType.RULE_SET);
    }

    public void addDeclaration(Declaration declaration) {
        this.addMember(declaration);
    }

    public void addRuleSet(RuleSet ruleSet) {
        this.addMember(ruleSet);
    }

    public void addChild(ASTCssNode child) {
        if (child.getType() != ASTCssNodeType.RULE_SET && child.getType() != ASTCssNodeType.VARIABLE_DECLARATION && child.getType() != ASTCssNodeType.DECLARATION && child.getType() != ASTCssNodeType.MEDIUM && child.getType() != ASTCssNodeType.MEDIA_QUERY) {
            throw new IllegalArgumentException("Unexpected media child type: " + (Object)((Object)child.getType()));
        }
        if (child.getType() == ASTCssNodeType.MEDIA_QUERY) {
            this.addMediaQuery((MediaQuery)child);
        } else {
            this.addMember(child);
        }
    }

    public void addMediaQuery(MediaQuery medium) {
        if (this.mediums == null) {
            this.mediums = new ArrayList<MediaQuery>();
        }
        this.mediums.add(medium);
    }

    public List<MediaQuery> getMediums() {
        return this.mediums;
    }

    public void setMediums(List<MediaQuery> mediums) {
        this.mediums = mediums;
    }

    @Override
    public List<ASTCssNode> getChilds() {
        ArrayList<ASTCssNode> childs = new ArrayList<ASTCssNode>(super.getChilds());
        childs.addAll(this.mediums);
        return childs;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MEDIA;
    }

    @Override
    public Media clone() {
        Media result = (Media)super.clone();
        result.mediums = ArraysUtils.deeplyClonedList(this.mediums);
        result.configureParentToAllChilds();
        return result;
    }
}

