/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MixinReference
extends ASTCssNode {
    private CssClass selector;
    private List<Expression> parameters = new ArrayList<Expression>();
    private boolean important = false;

    public MixinReference(HiddenTokenAwareTree token) {
        super(token);
    }

    public CssClass getSelector() {
        return this.selector;
    }

    public String getName() {
        return this.getSelector().getName();
    }

    public void setSelector(CssClass selector) {
        this.selector = selector;
    }

    public List<Expression> getParameters() {
        return this.parameters;
    }

    public boolean hasParameter(int parameterNumber) {
        return this.getParameters().size() > parameterNumber;
    }

    public Expression getParameter(int parameterNumber) {
        return this.getParameters().get(parameterNumber);
    }

    public void addParameter(Expression parameter) {
        this.parameters.add(parameter);
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.selector);
        result.addAll(this.parameters);
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.MIXIN_REFERENCE;
    }

    public String toString() {
        return "MixinReference[" + this.getName() + "]";
    }

    @Override
    public MixinReference clone() {
        MixinReference result = (MixinReference)super.clone();
        result.selector = this.selector == null ? null : this.selector.clone();
        result.parameters = ArraysUtils.deeplyClonedList(this.parameters);
        result.configureParentToAllChilds();
        return result;
    }

    public List<Expression> getAllArgumentsFrom(int startIndx) {
        if (this.hasParameter(startIndx)) {
            return this.parameters.subList(startIndx, this.parameters.size());
        }
        return Collections.emptyList();
    }
}

