/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class NestedRuleSet
extends RuleSet {
    private boolean appended;
    private SelectorCombinator leadingCombinator;

    public NestedRuleSet(HiddenTokenAwareTree underlyingStructure, boolean appended, SelectorCombinator leadingCombinator, RuleSet ruleSet) {
        super(underlyingStructure);
        this.appended = appended;
        this.leadingCombinator = leadingCombinator;
        this.setBody(ruleSet.getBody());
        this.addSelectors(ruleSet.getSelectors());
    }

    public boolean isAppended() {
        return this.appended;
    }

    public void setAppended(boolean appended) {
        this.appended = appended;
    }

    public SelectorCombinator getLeadingCombinator() {
        return this.leadingCombinator;
    }

    public void setLeadingCombinator(SelectorCombinator leadingCombinator) {
        this.leadingCombinator = leadingCombinator;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.leadingCombinator);
        result.addAll(super.getChilds());
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.NESTED_RULESET;
    }

    public RuleSet convertToRuleSet() {
        return new RuleSet(this.getUnderlyingStructure(), this.getBody(), this.getSelectors());
    }

    @Override
    public NestedRuleSet clone() {
        NestedRuleSet result = (NestedRuleSet)super.clone();
        result.leadingCombinator = this.leadingCombinator == null ? null : this.leadingCombinator.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

