/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.Guard;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class PureMixin
extends ASTCssNode {
    private CssClass selector;
    private List<ASTCssNode> parameters = new ArrayList<ASTCssNode>();
    private List<Guard> guards = new ArrayList<Guard>();
    private RuleSetsBody body;

    public PureMixin(HiddenTokenAwareTree token) {
        super(token);
    }

    public PureMixin(HiddenTokenAwareTree token, CssClass className) {
        this(token);
        this.selector = className;
    }

    public CssClass getSelector() {
        return this.selector;
    }

    public String getName() {
        return this.getSelector().getName();
    }

    public void setSelector(CssClass selector) {
        this.selector = selector;
    }

    public RuleSetsBody getBody() {
        return this.body;
    }

    public boolean hasEmptyBody() {
        return this.body == null ? true : this.body.isEmpty();
    }

    public void setBody(RuleSetsBody body) {
        this.body = body;
    }

    public List<ASTCssNode> getParameters() {
        return this.parameters;
    }

    public boolean hasCollectorParameter() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return false;
        }
        ASTCssNode last = this.parameters.get(this.parameters.size() - 1);
        if (last.getType() != ASTCssNodeType.ARGUMENT_DECLARATION) {
            return false;
        }
        return ((ArgumentDeclaration)last).isCollector();
    }

    public List<ASTCssNode> getMandatoryParameters() {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        for (ASTCssNode param : this.getParameters()) {
            ArgumentDeclaration declaration;
            if (param.getType() != ASTCssNodeType.ARGUMENT_DECLARATION || !(declaration = (ArgumentDeclaration)param).isMandatory()) continue;
            result.add(declaration);
        }
        return result;
    }

    public void addParameter(ASTCssNode parameter) {
        if (parameter.getType() != ASTCssNodeType.ARGUMENT_DECLARATION && !(parameter instanceof Expression)) {
            throw new IllegalArgumentException("The node can not be used as a mixin parameter: " + parameter);
        }
        this.parameters.add(parameter);
    }

    public List<Guard> getGuards() {
        return this.guards;
    }

    public void addGuard(Guard guard) {
        this.guards.add(guard);
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.selector, this.body);
        result.addAll(this.parameters);
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.PURE_MIXIN;
    }

    @Override
    public PureMixin clone() {
        PureMixin result = (PureMixin)super.clone();
        result.selector = this.selector == null ? null : this.selector.clone();
        result.parameters = ArraysUtils.deeplyClonedList(this.parameters);
        result.body = this.body == null ? null : this.body.clone();
        result.configureParentToAllChilds();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PureMixin [");
        builder.append(this.selector);
        builder.append("]");
        return builder.toString();
    }
}

