/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssClass;
import com.github.sommeri.less4j.core.ast.PureMixin;
import com.github.sommeri.less4j.core.ast.RuleSetsBody;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class RuleSet
extends ASTCssNode {
    private List<Selector> selectors = new ArrayList<Selector>();
    private RuleSetsBody body;

    public RuleSet(HiddenTokenAwareTree token) {
        super(token);
    }

    public RuleSet(HiddenTokenAwareTree token, RuleSetsBody body, List<Selector> selectors) {
        super(token);
        this.body = body;
        this.addSelectors(selectors);
        this.configureParentToAllChilds();
    }

    public List<Selector> getSelectors() {
        return this.selectors;
    }

    public RuleSetsBody getBody() {
        return this.body;
    }

    public boolean hasEmptyBody() {
        return this.body == null ? true : this.body.isEmpty();
    }

    public void setBody(RuleSetsBody body) {
        this.body = body;
    }

    public boolean isMixin() {
        if (this.selectors == null || this.selectors.size() != 1) {
            return false;
        }
        Selector first = this.selectors.get(0);
        if (first.isCombined()) {
            return false;
        }
        SimpleSelector selector = first.getHead();
        return selector.isSingleClassSelector();
    }

    public PureMixin convertToMixin() {
        CssClass className = (CssClass)this.selectors.get(0).getHead().getSubsequent().get(0);
        PureMixin pureMixin = new PureMixin(this.getUnderlyingStructure(), className.clone());
        pureMixin.setBody(this.getBody().clone());
        pureMixin.configureParentToAllChilds();
        return pureMixin;
    }

    @Override
    public List<? extends ASTCssNode> getChilds() {
        List<ASTCssNode> result = ArraysUtils.asNonNullList(this.body);
        result.addAll(0, this.selectors);
        return result;
    }

    public void addSelectors(List<Selector> selectors) {
        this.selectors.addAll(selectors);
    }

    public void replaceSelectors(List<Selector> result) {
        this.selectors = new ArrayList<Selector>();
        this.selectors.addAll(result);
    }

    @Override
    public RuleSet clone() {
        RuleSet result = (RuleSet)super.clone();
        result.body = this.body == null ? null : this.body.clone();
        result.selectors = ArraysUtils.deeplyClonedList(this.selectors);
        result.configureParentToAllChilds();
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.RULE_SET;
    }
}

