/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public class SimpleSelector
extends ASTCssNode
implements Cloneable {
    private String elementName;
    private boolean isStar;
    private boolean isEmptyForm = false;
    private List<ASTCssNode> subsequent = new ArrayList<ASTCssNode>();

    public SimpleSelector(HiddenTokenAwareTree token, String elementName, boolean isStar) {
        super(token);
        this.elementName = elementName;
        this.isStar = isStar;
    }

    public boolean isSingleClassSelector() {
        if (!this.isEmptyForm() || this.subsequent == null || this.subsequent.size() != 1) {
            return false;
        }
        return this.subsequent.get(0).getType() == ASTCssNodeType.CSS_CLASS;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isEmptyForm() {
        return this.isEmptyForm;
    }

    public void setEmptyForm(boolean isEmptyForm) {
        this.isEmptyForm = isEmptyForm;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public void setStar(boolean isStar) {
        this.isStar = isStar;
    }

    public boolean hasElement() {
        return null != this.getElementName();
    }

    public List<ASTCssNode> getSubsequent() {
        return this.subsequent;
    }

    public void addSubsequent(ASTCssNode subsequent) {
        this.subsequent.add(subsequent);
    }

    public void addSubsequent(List<ASTCssNode> subsequent) {
        this.subsequent.addAll(subsequent);
    }

    public List<ASTCssNode> getChilds() {
        return new ArrayList<ASTCssNode>(this.subsequent);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SIMPLE_SELECTOR;
    }

    @Override
    public SimpleSelector clone() {
        SimpleSelector clone = (SimpleSelector)super.clone();
        clone.subsequent = ArraysUtils.deeplyClonedList(this.getSubsequent());
        clone.configureParentToAllChilds();
        return clone;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isStar ? "*" : this.getElementName());
        builder.append(this.subsequent);
        return builder.toString();
    }
}

