/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.AbstractVariableDeclaration;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.PureMixin;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.CompileException;
import com.github.sommeri.less4j.core.compiler.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.MixinsReferenceMatcher;
import com.github.sommeri.less4j.core.compiler.MixinsScope;
import com.github.sommeri.less4j.core.compiler.VariablesScope;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ActiveScope {
    private Stack<VariablesScope> variablesScope = new Stack();
    private Stack<MixinsScope> mixinsScope = new Stack();

    public ActiveScope() {
        this.variablesScope.push(new VariablesScope());
        this.mixinsScope.push(new MixinsScope());
    }

    public void addDeclaration(AbstractVariableDeclaration node) {
        this.variablesScope.peek().addDeclaration(node);
    }

    public void addDeclaration(AbstractVariableDeclaration node, Expression replacementValue) {
        this.variablesScope.peek().addDeclaration(node, replacementValue);
    }

    public void addDeclaration(Map<String, Expression> variablesState, ArgumentDeclaration node, Expression replacementValue) {
        variablesState.put(node.getVariable().getName(), replacementValue);
    }

    public void decreaseScope() {
        this.variablesScope.pop();
        this.mixinsScope.pop();
    }

    public void increaseScope() {
        VariablesScope oldVariables = this.variablesScope.peek();
        this.variablesScope.push(new VariablesScope(oldVariables));
        this.mixinsScope.push(new MixinsScope());
    }

    public Expression getDeclaredValue(Variable node) {
        String name = node.getName();
        Expression expression = this.variablesScope.peek().getValue(name);
        if (expression == null) {
            CompileException.throwUndeclaredVariable(node);
        }
        return expression;
    }

    public Expression getDeclaredValue(String name, ASTCssNode ifErrorNode) {
        Expression expression = this.variablesScope.peek().getValue(name);
        if (expression == null) {
            CompileException.throwUndeclaredVariable(name, ifErrorNode);
        }
        return expression;
    }

    public List<FullMixinDefinition> getAllMatchingMixins(MixinsReferenceMatcher matcher, MixinReference reference) {
        int idx = this.mixinsScope.size();
        while (idx > 0) {
            MixinsScope idxScope;
            if (!(idxScope = (MixinsScope)this.mixinsScope.elementAt(--idx)).contains(reference.getName())) continue;
            return matcher.filter(reference, idxScope.getMixins(reference.getName()));
        }
        throw CompileException.createUndeclaredMixin(reference);
    }

    public void leaveMixinVariableScope() {
        this.variablesScope.pop();
    }

    public void registerMixin(PureMixin node) {
        VariablesScope variablesState = this.variablesScope.peek().clone();
        FullMixinDefinition mixin = new FullMixinDefinition(node, variablesState);
        this.mixinsScope.peek().registerMixin(mixin);
    }

    public void enterMixinVariableScope(VariablesScope variablesUponDefinition) {
        this.variablesScope.push(variablesUponDefinition);
    }
}

