/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.PureMixin;
import com.github.sommeri.less4j.core.compiler.ActiveScope;
import com.github.sommeri.less4j.core.compiler.ExpressionComparator;
import com.github.sommeri.less4j.core.compiler.ExpressionEvaluator;
import com.github.sommeri.less4j.core.compiler.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.PatternsComparator;
import java.util.ArrayList;
import java.util.List;

public class MixinsReferenceMatcher {
    private ExpressionEvaluator evaluator;
    private ExpressionComparator comparator = new PatternsComparator();

    public MixinsReferenceMatcher(ActiveScope activeScope) {
        this.evaluator = new ExpressionEvaluator(activeScope);
    }

    public List<FullMixinDefinition> filter(MixinReference reference, List<FullMixinDefinition> mixins) {
        return this.filterByParametersNumber(reference, mixins);
    }

    private List<FullMixinDefinition> filterByParametersNumber(MixinReference reference, List<FullMixinDefinition> mixins) {
        int requiredNumber = reference.getParameters().size();
        ArrayList<FullMixinDefinition> result = new ArrayList<FullMixinDefinition>();
        for (FullMixinDefinition mixinDefinition : mixins) {
            if (!this.hasRightNumberOfParameters(mixinDefinition, requiredNumber)) continue;
            result.add(mixinDefinition);
        }
        return result;
    }

    private boolean hasRightNumberOfParameters(FullMixinDefinition mixinDefinition, int requiredNumber) {
        PureMixin mixin = mixinDefinition.getMixin();
        int allDefined = mixin.getParameters().size();
        int mandatory = mixin.getMandatoryParameters().size();
        boolean hasRightNumberOfParameters = requiredNumber >= mandatory && (requiredNumber <= allDefined || mixin.hasCollectorParameter());
        return hasRightNumberOfParameters;
    }

    public boolean patternsMatch(MixinReference reference, FullMixinDefinition mixin) {
        int i = 0;
        for (ASTCssNode parameter : mixin.getMixin().getParameters()) {
            if (parameter instanceof Expression) {
                if (!reference.hasParameter(i)) {
                    return false;
                }
                Expression pattern = (Expression)parameter;
                if (!this.comparator.equal(pattern, this.evaluator.evaluate(reference.getParameter(i)))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

