/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Body;
import com.github.sommeri.less4j.core.ast.NestedRuleSet;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.CompileException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class NestedRulesCollector {
    private Stack<List<Selector>> selectors;
    private LinkedList<NestedRuleSet> rulesets;

    public List<NestedRuleSet> collectNestedRuleSets(RuleSet kid) {
        this.selectors = new Stack();
        this.rulesets = new LinkedList();
        this.pushSelectors(kid);
        this.collectChildRuleSets(kid);
        this.popSelectors();
        return this.rulesets;
    }

    private void collectChildRuleSets(ASTCssNode node) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            if (aSTCssNode.getType() == ASTCssNodeType.NESTED_RULESET) {
                NestedRuleSet nestedSet = (NestedRuleSet)aSTCssNode;
                this.removeFromParent(nestedSet);
                this.collect(nestedSet);
                this.pushSelectors(nestedSet);
            }
            this.collectChildRuleSets(aSTCssNode);
            if (aSTCssNode.getType() != ASTCssNodeType.NESTED_RULESET) continue;
            this.popSelectors();
        }
    }

    private void collect(NestedRuleSet nestedSet) {
        this.combine(nestedSet, this.selectors.peek(), nestedSet.isAppended());
        this.rulesets.add(nestedSet);
    }

    public void combine(RuleSet ruleSet, List<Selector> previousSelectors, boolean append) {
        List<Selector> innerSelectors = ruleSet.getSelectors();
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector inner : innerSelectors) {
            for (Selector outer : previousSelectors) {
                Selector outerClone = outer.clone();
                Selector innerClone = inner.clone();
                Selector rightestClone = outerClone.getRightestPart();
                if (append) {
                    rightestClone.getHead().addSubsequent(innerClone.getHead().getSubsequent());
                    rightestClone.getHead().configureParentToAllChilds();
                } else {
                    rightestClone.setRight(innerClone);
                    innerClone.setParent(rightestClone);
                }
                result.add(outerClone);
            }
        }
        ruleSet.replaceSelectors(result);
        ruleSet.configureParentToAllChilds();
    }

    private void removeFromParent(NestedRuleSet nestedSet) {
        ASTCssNode parent = nestedSet.getParent();
        if (!(parent instanceof Body)) {
            throw new CompileException("Does not belong to body.", (ASTCssNode)nestedSet);
        }
        Body body = (Body)parent;
        body.removeMember(nestedSet);
        nestedSet.setParent(null);
    }

    private void pushSelectors(RuleSet kid) {
        this.selectors.push(new ArrayList<Selector>(kid.getSelectors()));
    }

    private void popSelectors() {
        this.selectors.pop();
    }
}

